/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ReflectionEqualsMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final String[] excludedFields;
    private final T object;

    private ReflectionEqualsMatcher(T object, String ... excludedFields) {
        this.excludedFields = excludedFields;
        this.object = object;
    }

    @Factory
    public static <T> Matcher<T> reflectEquals(T target, String ... excludedFields) {
        return new ReflectionEqualsMatcher<T>(target, excludedFields);
    }

    protected boolean matchesSafely(T item, Description mismatchDescription) {
        if (EqualsBuilder.reflectionEquals(item, this.object, (String[])this.excludedFields)) {
            return true;
        }
        mismatchDescription.appendText("was: ").appendText(this.getStringRepresentation(item, this.excludedFields));
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("reflectively equal to: " + this.getStringRepresentation(this.object, this.excludedFields));
    }

    private String getStringRepresentation(Object o, String ... excludedFields) {
        return new ReflectionToStringBuilder(o, ToStringStyle.MULTI_LINE_STYLE).setExcludeFieldNames(excludedFields).toString();
    }
}

