/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class SerializableMatcher
extends DiagnosingMatcher<Object> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean matches(Object item, Description mismatchDescription) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(item);
        }
        catch (NotSerializableException nse) {
            boolean bl;
            try {
                mismatchDescription.appendText("not serializable");
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    oos.close();
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            oos.close();
            return bl;
        }
        oos.close();
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("serializable");
    }

    @Factory
    public static Matcher<Object> serializable() {
        return new SerializableMatcher();
    }
}

