/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.matchers;

import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class StringMatchers {
    private StringMatchers() {
    }

    @Factory
    public static Matcher<String> containsIgnoreCase(final String substring) {
        return new TypeSafeDiagnosingMatcher<String>(){

            protected boolean matchesSafely(String item, Description mismatchDescription) {
                mismatchDescription.appendValue((Object)item).appendText(" did not contain ignoring case: ").appendValue((Object)substring);
                return StringUtils.containsIgnoreCase((CharSequence)item, (CharSequence)substring);
            }

            public void describeTo(Description description) {
                description.appendText("contains ignoring case ").appendValue((Object)substring);
            }
        };
    }
}

