/*
 * Decompiled with CFR 0.152.
 */
package com.nitorcreations.willow.sshagentauth;

import com.jcraft.jsch.Identity;
import com.nitorcreations.willow.sshagentauth.SSHAuthentication;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public abstract class AbstractSSHAuthentication
implements SSHAuthentication {
    private static Logger logger = Logger.getLogger(AbstractSSHAuthentication.class.getCanonicalName());

    public String getSshSignatures(byte[] sign, List<Identity> identities) {
        StringBuilder ret = new StringBuilder();
        for (Identity id : identities) {
            try {
                byte[] sig = id.getSignature(sign);
                if (sig == null) continue;
                ret.append(" ").append(DatatypeConverter.printBase64Binary((byte[])sig));
            }
            catch (Exception t) {
                logger.log(Level.FINE, "Failed to add signature: " + t.getMessage());
            }
        }
        return ret.toString();
    }
}

