/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-cronutils-js/cron_scheduler */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JCronScheduler = Java.type('com.noenv.cronutils.CronScheduler');

/**
 Creates CronScheduler instances.

 @class
*/
var CronScheduler = function(j_val) {

  var j_cronScheduler = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_schedule = this.schedule;
  var __super_cancel = this.cancel;
  /**
   Register a handler and start the scheduler

   @public
   @param handler {function} the handler will be provided with a reference to the scheduler 
   @return {CronScheduler}
   */
  this.schedule =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_cronScheduler["schedule(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnVertxGen(CronScheduler, jVal));
      }) ;
      return that;
    } else if (typeof __super_schedule != 'undefined') {
      return __super_schedule.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   */
  this.cancel =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_cronScheduler["cancel()"]();
    } else if (typeof __super_cancel != 'undefined') {
      return __super_cancel.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_cronScheduler;
};

CronScheduler._jclass = utils.getJavaClass("com.noenv.cronutils.CronScheduler");
CronScheduler._jtype = {accept: function(obj) {
    return CronScheduler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(CronScheduler.prototype, {});
    CronScheduler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
CronScheduler._create = function(jdel) {var obj = Object.create(CronScheduler.prototype, {});
  CronScheduler.apply(obj, arguments);
  return obj;
}
/**
 Create a CronScheduler.

 @memberof module:vertx-cronutils-js/cron_scheduler
 @param vertx {Vertx} the Vert.x instance 
 @param cron {string} the cron expression 
 @param type {Object} the cron type 
 @return {CronScheduler} the instance
 */
CronScheduler.create =  function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(CronScheduler, JCronScheduler["create(io.vertx.core.Vertx,java.lang.String)"](__args[0]._jdel, __args[1])) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
    return utils.convReturnVertxGen(CronScheduler, JCronScheduler["create(io.vertx.core.Vertx,java.lang.String,com.cronutils.model.CronType)"](__args[0]._jdel, __args[1], com.cronutils.model.CronType.valueOf(__args[2]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = CronScheduler;