require 'vertx/vertx'
require 'vertx/util/utils.rb'
# Generated from com.noenv.cronutils.CronScheduler
module VertxCronutils
  #  Creates CronScheduler instances.
  class CronScheduler
    # @private
    # @param j_del [::VertxCronutils::CronScheduler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCronutils::CronScheduler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CronScheduler
    end
    def @@j_api_type.wrap(obj)
      CronScheduler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::ComNoenvCronutils::CronScheduler.java_class
    end
    #  Create a CronScheduler.
    # @param [::Vertx::Vertx] vertx the Vert.x instance
    # @param [String] cron the cron expression
    # @param [:CRON4J,:QUARTZ,:UNIX,:SPRING] type the cron type
    # @return [::VertxCronutils::CronScheduler] the instance
    def self.create(vertx=nil,cron=nil,type=nil)
      if vertx.class.method_defined?(:j_del) && cron.class == String && !block_given? && type == nil
        return ::Vertx::Util::Utils.safe_create(Java::ComNoenvCronutils::CronScheduler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(vertx.j_del,cron),::VertxCronutils::CronScheduler)
      elsif vertx.class.method_defined?(:j_del) && cron.class == String && type.class == Symbol && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::ComNoenvCronutils::CronScheduler.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::ComCronutilsModel::CronType.java_class]).call(vertx.j_del,cron,Java::ComCronutilsModel::CronType.valueOf(type.to_s)),::VertxCronutils::CronScheduler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{cron},#{type})"
    end
    #  Register a handler and start the scheduler
    # @yield the handler will be provided with a reference to the scheduler
    # @return [self]
    def schedule
      if block_given?
        @j_del.java_method(:schedule, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxCronutils::CronScheduler)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling schedule()"
    end
    # @return [void]
    def cancel
      if !block_given?
        return @j_del.java_method(:cancel, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling cancel()"
    end
  end
end
