/*
 * Decompiled with CFR 0.152.
 */
package com.noenv.cronutils;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.noenv.cronutils.impl.CronSchedulerImpl;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.time.ZoneId;

@VertxGen
public interface CronScheduler {
    public static CronScheduler create(Vertx vertx, String cron) {
        CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        return new CronSchedulerImpl(vertx, cron, definition, ZoneId.systemDefault());
    }

    public static CronScheduler create(Vertx vertx, String cron, CronType type) {
        CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)type);
        return new CronSchedulerImpl(vertx, cron, definition, ZoneId.systemDefault());
    }

    public static CronScheduler create(Vertx vertx, String cron, String zoneId) {
        CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        return new CronSchedulerImpl(vertx, cron, definition, ZoneId.of(zoneId));
    }

    public static CronScheduler create(Vertx vertx, String cron, CronType type, String zoneId) {
        CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)type);
        return new CronSchedulerImpl(vertx, cron, definition, ZoneId.of(zoneId));
    }

    @GenIgnore
    public static CronScheduler create(Vertx vertx, String cron, CronDefinition definition, ZoneId zoneId) {
        return new CronSchedulerImpl(vertx, cron, definition, zoneId);
    }

    @Fluent
    public CronScheduler schedule(Handler<CronScheduler> var1);

    public void cancel();

    public boolean active();

    public String zoneId();
}

