/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.app.Activity;
import android.app.ListFragment;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Loader;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.CheckedTextView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.nononsenseapps.filepicker.BindableArrayAdapter;
import com.nononsenseapps.filepicker.NewFolderFragment;
import com.nononsenseapps.filepicker.NewItemFragment;
import com.nononsenseapps.filepicker.R;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractFilePickerFragment<T>
extends ListFragment
implements LoaderManager.LoaderCallbacks<List<T>>,
NewItemFragment.OnNewFolderListener,
AdapterView.OnItemLongClickListener {
    public static final String KEY_START_PATH = "KEY_START_PATH";
    public static final String KEY_ONLY_DIRS = "KEY_ONLY_DIRS";
    public static final String KEY_ALLOW_MULTIPLE = "KEY_ALLOW_MULTIPLE";
    private static final String KEY_CURRENT_PATH = "KEY_START_PATH";
    protected T currentPath = null;
    protected boolean onlyDirs = false;
    protected boolean allowMultiple = false;
    protected Comparator<T> comparator = null;
    private OnFilePickedListener listener;
    private BindableArrayAdapter<T> adapter;
    private TextView currentDirView;
    private View okButton;
    protected final DefaultHashMap<Integer, Boolean> checkedItems = new DefaultHashMap(false);

    public void setArgs(String startPath, boolean onlyDirs, boolean allowMultiple) {
        Bundle b = new Bundle();
        if (startPath != null) {
            b.putString("KEY_START_PATH", startPath);
        }
        b.putBoolean(KEY_ONLY_DIRS, onlyDirs);
        b.putBoolean(KEY_ALLOW_MULTIPLE, allowMultiple);
        this.setArguments(b);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        if (this.currentPath == null) {
            if (savedInstanceState != null) {
                this.onlyDirs = savedInstanceState.getBoolean(KEY_ONLY_DIRS, this.onlyDirs);
                this.allowMultiple = savedInstanceState.getBoolean(KEY_ALLOW_MULTIPLE, this.allowMultiple);
                this.currentPath = this.getPath(savedInstanceState.getString("KEY_START_PATH"));
            } else if (this.getArguments() != null) {
                this.onlyDirs = this.getArguments().getBoolean(KEY_ONLY_DIRS, this.onlyDirs);
                this.allowMultiple = this.getArguments().getBoolean(KEY_ALLOW_MULTIPLE, this.allowMultiple);
                if (this.getArguments().containsKey("KEY_START_PATH")) {
                    this.currentPath = this.getPath(this.getArguments().getString("KEY_START_PATH"));
                }
            }
            if (this.currentPath == null) {
                this.currentPath = this.getRoot();
            }
        }
        this.refresh();
        this.setHasOptionsMenu(true);
    }

    private boolean isCheckable() {
        return this.allowMultiple || !this.onlyDirs;
    }

    protected void refresh() {
        this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_filepicker, null);
        ListView lv = (ListView)view.findViewById(16908298);
        lv.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        view.findViewById(R.id.button_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AbstractFilePickerFragment.this.listener != null) {
                    AbstractFilePickerFragment.this.listener.onCancelled();
                }
            }
        });
        this.okButton = view.findViewById(R.id.button_ok);
        if (this.allowMultiple) {
            this.okButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AbstractFilePickerFragment.this.listener != null) {
                        AbstractFilePickerFragment.this.listener.onFilesPicked(AbstractFilePickerFragment.this.toUri(AbstractFilePickerFragment.this.getCheckedItems()));
                    }
                }
            });
        } else {
            this.okButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AbstractFilePickerFragment.this.listener != null) {
                        AbstractFilePickerFragment.this.listener.onFilePicked(AbstractFilePickerFragment.this.toUri(AbstractFilePickerFragment.this.currentPath));
                    }
                }
            });
        }
        view.findViewById(R.id.button_go_parent).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractFilePickerFragment.this.currentPath = AbstractFilePickerFragment.this.getParent(AbstractFilePickerFragment.this.currentPath);
                AbstractFilePickerFragment.this.refresh();
            }
        });
        view.findViewById(R.id.button_create_dir).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewFolderFragment.showDialog(AbstractFilePickerFragment.this.getFragmentManager(), AbstractFilePickerFragment.this);
            }
        });
        this.currentDirView = (TextView)view.findViewById(R.id.current_dir);
        if (this.currentPath != null) {
            this.currentDirView.setText((CharSequence)this.getFullPath(this.currentPath));
        }
        return view;
    }

    private List<Uri> toUri(List<T> files) {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (T file : files) {
            uris.add(this.toUri(file));
        }
        return uris;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.listener = (OnFilePickedListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement OnFilePickedListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void onSaveInstanceState(Bundle b) {
        super.onSaveInstanceState(b);
        b.putString("KEY_START_PATH", this.currentPath.toString());
        b.putBoolean(KEY_ALLOW_MULTIPLE, this.allowMultiple);
        b.putBoolean(KEY_ONLY_DIRS, this.onlyDirs);
    }

    protected abstract boolean isDir(T var1);

    public void onListItemClick(ListView l, View v, int position, long id2) {
        super.onListItemClick(l, v, position, id2);
        this.currentPath = this.getListAdapter().getItem(position);
        if (this.isDir(this.currentPath)) {
            this.refresh();
        } else if (this.isCheckable()) {
            this.toggleItemCheck((CheckedTextView)v.findViewById(16908308), position);
        }
    }

    private void toggleItemCheck(CheckedTextView view, int position) {
        if (!this.isCheckable()) {
            return;
        }
        boolean oldVal = this.checkedItems.get(position);
        if (!this.allowMultiple) {
            this.checkedItems.clear();
        }
        this.checkedItems.put(position, !oldVal);
        this.getListView().invalidateViews();
    }

    protected List<T> getCheckedItems() {
        BindableArrayAdapter adapter = (BindableArrayAdapter)this.getListAdapter();
        ArrayList<Object> files = new ArrayList<Object>();
        Iterator i$ = this.checkedItems.keySet().iterator();
        while (i$.hasNext()) {
            int pos = (Integer)i$.next();
            if (!this.checkedItems.get(pos).booleanValue()) continue;
            files.add(adapter.getItem(pos));
        }
        return files;
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        if (!this.isCheckable()) {
            return false;
        }
        if (!this.allowMultiple) {
            return false;
        }
        this.toggleItemCheck((CheckedTextView)view.findViewById(16908308), position);
        return true;
    }

    protected abstract T getParent(T var1);

    protected abstract T getPath(String var1);

    protected abstract String getFullPath(T var1);

    protected abstract String getName(T var1);

    protected abstract T getRoot();

    protected abstract Uri toUri(T var1);

    protected abstract Comparator<T> getComparator();

    protected BindableArrayAdapter.ViewBinder<T> getViewBinder() {
        return new BindableArrayAdapter.ViewBinder<T>(){

            @Override
            public void setViewValue(View view, int position, T data) {
                class ViewHolder {
                    protected View icon;
                    protected TextView text;
                    protected CheckedTextView checkbox;

                    ViewHolder() {
                    }
                }
                if (view.getTag() == null) {
                    ViewHolder viewHolder = new ViewHolder();
                    viewHolder.icon = view.findViewById(R.id.item_icon);
                    viewHolder.text = (TextView)view.findViewById(16908308);
                    if (AbstractFilePickerFragment.this.isCheckable()) {
                        viewHolder.checkbox = (CheckedTextView)view.findViewById(16908308);
                    }
                    view.setTag((Object)viewHolder);
                }
                ((ViewHolder)view.getTag()).text.setText((CharSequence)AbstractFilePickerFragment.this.getName(data));
                ((ViewHolder)view.getTag()).icon.setVisibility(AbstractFilePickerFragment.this.isDir(data) ? 0 : 8);
                if (((ViewHolder)view.getTag()).checkbox != null) {
                    ((ViewHolder)view.getTag()).checkbox.setChecked(AbstractFilePickerFragment.this.checkedItems.get(position).booleanValue());
                }
            }
        };
    }

    protected abstract Loader<List<T>> getLoader();

    public Loader<List<T>> onCreateLoader(int id2, Bundle args) {
        return this.getLoader();
    }

    public void onLoadFinished(Loader<List<T>> loader, List<T> data) {
        if (this.adapter == null) {
            this.adapter = new BindableArrayAdapter((Context)this.getActivity(), this.isCheckable() ? R.layout.filepicker_listitem_checkable : R.layout.filepicker_listitem_dir);
            this.adapter.setViewBinder(this.getViewBinder());
        } else {
            this.adapter.clear();
        }
        if (this.comparator == null) {
            this.comparator = this.getComparator();
        }
        this.checkedItems.clear();
        this.adapter.addAll(data);
        this.adapter.sort(this.comparator);
        this.setListAdapter((ListAdapter)this.adapter);
        this.adapter.notifyDataSetChanged();
        this.currentDirView.setText((CharSequence)this.getFullPath(this.currentPath));
    }

    public void onLoaderReset(Loader<List<T>> loader) {
        this.setListAdapter(null);
        this.adapter = null;
    }

    public class DefaultHashMap<K, V>
    extends HashMap<K, V> {
        protected final V defaultValue;

        public DefaultHashMap(V defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public V get(Object k) {
            return this.containsKey(k) ? super.get(k) : this.defaultValue;
        }
    }

    public static interface OnFilePickedListener {
        public void onFilePicked(Uri var1);

        public void onFilesPicked(List<Uri> var1);

        public void onCancelled();
    }
}

