/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import java.util.List;

public class BindableArrayAdapter<T>
extends ArrayAdapter<T> {
    private final LayoutInflater mInflater;
    private final int mResource;
    private ViewBinder<T> viewBinder = null;

    public BindableArrayAdapter(Context context, int resource) {
        super(context, resource);
        this.mResource = resource;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public BindableArrayAdapter(Context context, int resource, int textViewResourceId) {
        super(context, resource, textViewResourceId);
        this.mResource = resource;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public BindableArrayAdapter(Context context, int resource, T[] objects) {
        super(context, resource, (Object[])objects);
        this.mResource = resource;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public BindableArrayAdapter(Context context, int resource, int textViewResourceId, T[] objects) {
        super(context, resource, textViewResourceId, (Object[])objects);
        this.mResource = resource;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public BindableArrayAdapter(Context context, int resource, List<T> objects) {
        super(context, resource, objects);
        this.mResource = resource;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public BindableArrayAdapter(Context context, int resource, int textViewResourceId, List<T> objects) {
        super(context, resource, textViewResourceId, objects);
        this.mResource = resource;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public void setViewBinder(ViewBinder binder) {
        this.viewBinder = binder;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (this.viewBinder == null) {
            return super.getView(position, convertView, parent);
        }
        View view = convertView == null ? this.mInflater.inflate(this.mResource, parent, false) : convertView;
        this.viewBinder.setViewValue(view, position, this.getItem(position));
        return view;
    }

    public static interface ViewBinder<T> {
        public void setViewValue(View var1, int var2, T var3);
    }
}

