/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.content.AsyncTaskLoader;
import android.content.Context;
import android.content.Loader;
import android.net.Uri;
import android.os.Environment;
import android.os.FileObserver;
import android.widget.Toast;
import com.nononsenseapps.filepicker.AbstractFilePickerFragment;
import com.nononsenseapps.filepicker.R;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FilePickerFragment
extends AbstractFilePickerFragment<File> {
    @Override
    protected boolean isDir(File path) {
        return path.isDirectory();
    }

    @Override
    protected File getParent(File from) {
        if (from.getParentFile() != null) {
            if (from.isFile()) {
                return this.getParent(from.getParentFile());
            }
            return from.getParentFile();
        }
        return from;
    }

    @Override
    protected File getPath(String path) {
        return new File(path);
    }

    @Override
    protected String getFullPath(File path) {
        return path.getPath();
    }

    @Override
    protected String getName(File path) {
        return path.getName();
    }

    @Override
    protected File getRoot() {
        return Environment.getExternalStorageDirectory();
    }

    @Override
    protected Uri toUri(File file) {
        return Uri.fromFile((File)file);
    }

    @Override
    protected Comparator<File> getComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                if (lhs.isDirectory() && !rhs.isDirectory()) {
                    return -1;
                }
                if (rhs.isDirectory() && !lhs.isDirectory()) {
                    return 1;
                }
                return lhs.getName().toLowerCase().compareTo(rhs.getName().toLowerCase());
            }
        };
    }

    @Override
    protected Loader<List<File>> getLoader() {
        return new AsyncTaskLoader<List<File>>((Context)this.getActivity()){
            FileObserver fileObserver;

            public List<File> loadInBackground() {
                ArrayList<File> files = new ArrayList<File>();
                for (File f : ((File)FilePickerFragment.this.currentPath).listFiles()) {
                    if (FilePickerFragment.this.mode != 0 && FilePickerFragment.this.mode != 2 && !f.isDirectory()) continue;
                    files.add(f);
                }
                return files;
            }

            protected void onStartLoading() {
                super.onStartLoading();
                if (FilePickerFragment.this.currentPath == null || !((File)FilePickerFragment.this.currentPath).isDirectory()) {
                    FilePickerFragment.this.currentPath = FilePickerFragment.this.getRoot();
                }
                this.fileObserver = new FileObserver(((File)FilePickerFragment.this.currentPath).getPath(), 960){

                    public void onEvent(int event, String path) {
                        this.onContentChanged();
                    }
                };
                this.fileObserver.startWatching();
                this.forceLoad();
            }

            protected void onReset() {
                super.onReset();
                if (this.fileObserver != null) {
                    this.fileObserver.stopWatching();
                    this.fileObserver = null;
                }
            }
        };
    }

    @Override
    public void onNewFolder(String name) {
        File folder = new File((File)this.currentPath, name);
        if (folder.mkdir()) {
            this.currentPath = folder;
            this.refresh();
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.create_folder_error, (int)0).show();
        }
    }
}

