/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.WindowManager;
import com.nononsenseapps.filepicker.AbstractFilePickerFragment;
import com.nononsenseapps.filepicker.R;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilePickerActivity<T>
extends Activity
implements AbstractFilePickerFragment.OnFilePickedListener {
    public static final String EXTRA_START_PATH = "nononsense.intent.START_PATH";
    public static final String EXTRA_MODE = "nononsense.intent.MODE";
    public static final String EXTRA_ALLOW_CREATE_DIR = "nononsense.intent.ALLOW_CREATE_DIR";
    public static final String EXTRA_ALLOW_MULTIPLE = "android.intent.extra.ALLOW_MULTIPLE";
    public static final String EXTRA_PATHS = "nononsense.intent.PATHS";
    public static final int MODE_FILE = 0;
    public static final int MODE_FILE_AND_DIR = 2;
    public static final int MODE_DIR = 1;
    protected static final String TAG = "filepicker_fragment";
    protected String startPath = null;
    protected int mode = 0;
    protected boolean allowCreateDir = false;
    protected boolean allowMultiple = false;

    protected void onCreate(Bundle savedInstanceState) {
        FragmentManager fm;
        AbstractFilePickerFragment<T> fragment;
        this.requestWindowFeature(8);
        this.setupFauxDialog();
        this.setupActionBar();
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_filepicker);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.startPath = intent.getStringExtra(EXTRA_START_PATH);
            this.mode = intent.getIntExtra(EXTRA_MODE, this.mode);
            this.allowCreateDir = intent.getBooleanExtra(EXTRA_ALLOW_CREATE_DIR, this.allowCreateDir);
            this.allowMultiple = intent.getBooleanExtra(EXTRA_ALLOW_MULTIPLE, this.allowMultiple);
        }
        if ((fragment = (AbstractFilePickerFragment<T>)(fm = this.getFragmentManager()).findFragmentByTag(TAG)) == null) {
            fragment = this.getFragment(this.startPath, this.mode, this.allowMultiple, this.allowCreateDir);
        }
        if (fragment != null) {
            fm.beginTransaction().replace(R.id.fragment, (Fragment)fragment, TAG).commit();
        }
        this.setResult(0);
    }

    protected void setupFauxDialog() {
        TypedValue tv = new TypedValue();
        if (!this.getTheme().resolveAttribute(R.attr.isDialog, tv, true) || tv.data == 0) {
            return;
        }
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.width = this.getResources().getDimensionPixelSize(R.dimen.configure_dialog_width);
        params.height = Math.min(this.getResources().getDimensionPixelSize(R.dimen.configure_dialog_max_height), dm.heightPixels * 3 / 4);
        params.alpha = 1.0f;
        params.dimAmount = 0.5f;
        this.getWindow().setAttributes(params);
    }

    protected void setupActionBar() {
        this.getActionBar().setTitle((CharSequence)this.getWindowTitle());
    }

    protected abstract AbstractFilePickerFragment<T> getFragment(String var1, int var2, boolean var3, boolean var4);

    protected String getWindowTitle() {
        int res;
        switch (this.mode) {
            case 1: {
                res = R.plurals.select_dir;
                break;
            }
            case 2: {
                res = R.plurals.select_dir_or_file;
                break;
            }
            default: {
                res = R.plurals.select_file;
            }
        }
        int count = this.allowMultiple ? 99 : 1;
        return this.getResources().getQuantityString(res, count);
    }

    public void onSaveInstanceState(Bundle b) {
        super.onSaveInstanceState(b);
    }

    @Override
    public void onFilePicked(Uri file) {
        Intent i = new Intent();
        i.setData(file);
        this.setResult(-1, i);
        this.finish();
    }

    @Override
    @TargetApi(value=16)
    public void onFilesPicked(List<Uri> files) {
        Intent i = new Intent();
        i.putExtra(EXTRA_ALLOW_MULTIPLE, true);
        if (Build.VERSION.SDK_INT >= 16) {
            ClipData clip = null;
            for (Uri file : files) {
                if (clip == null) {
                    clip = new ClipData((CharSequence)"Paths", new String[0], new ClipData.Item(file));
                    continue;
                }
                clip.addItem(new ClipData.Item(file));
            }
            i.setClipData(clip);
        } else {
            ArrayList<String> paths = new ArrayList<String>();
            for (Uri file : files) {
                paths.add(file.toString());
            }
            i.putStringArrayListExtra(EXTRA_PATHS, paths);
        }
        this.setResult(-1, i);
        this.finish();
    }

    @Override
    public void onCancelled() {
        this.setResult(0);
        this.finish();
    }
}

