/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.nononsenseapps.filepicker.AbstractFilePickerFragment;
import com.nononsenseapps.filepicker.LogicHandler;

public class FileItemAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final LogicHandler<T> mLogic;
    private SortedList<T> mList = null;

    public FileItemAdapter(LogicHandler<T> logic) {
        this.mLogic = logic;
    }

    public void setList(SortedList<T> list) {
        this.mList = list;
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.mLogic.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int headerPosition) {
        if (headerPosition == 0) {
            this.mLogic.onBindHeaderViewHolder((AbstractFilePickerFragment.HeaderViewHolder)viewHolder);
        } else {
            int pos = headerPosition - 1;
            this.mLogic.onBindViewHolder((AbstractFilePickerFragment.DirViewHolder)viewHolder, pos, this.mList.get(pos));
        }
    }

    public int getItemViewType(int headerPosition) {
        if (0 == headerPosition) {
            return 0;
        }
        int pos = headerPosition - 1;
        return this.mLogic.getItemViewType(pos, this.mList.get(pos));
    }

    public int getItemCount() {
        if (this.mList == null) {
            return 0;
        }
        return 1 + this.mList.size();
    }
}

