/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.util.SortedList;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.nononsenseapps.filepicker.DividerItemDecoration;
import com.nononsenseapps.filepicker.FileItemAdapter;
import com.nononsenseapps.filepicker.LogicHandler;
import com.nononsenseapps.filepicker.NewFolderFragment;
import com.nononsenseapps.filepicker.NewItemFragment;
import com.nononsenseapps.filepicker.R;
import com.nononsenseapps.filepicker.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractFilePickerFragment<T>
extends Fragment
implements LoaderManager.LoaderCallbacks<SortedList<T>>,
NewItemFragment.OnNewFolderListener,
LogicHandler<T> {
    public static final int MODE_FILE = 0;
    public static final int MODE_DIR = 1;
    public static final int MODE_FILE_AND_DIR = 2;
    public static final int MODE_NEW_FILE = 3;
    public static final String KEY_START_PATH = "KEY_START_PATH";
    public static final String KEY_MODE = "KEY_MODE";
    public static final String KEY_ALLOW_DIR_CREATE = "KEY_ALLOW_DIR_CREATE";
    public static final String KEY_ALLOW_MULTIPLE = "KEY_ALLOW_MULTIPLE";
    public static final String KEY_ALLOW_EXISTING_FILE = "KEY_ALLOW_EXISTING_FILE";
    public static final String KEY_SINGLE_CLICK = "KEY_SINGLE_CLICK";
    protected static final String KEY_CURRENT_PATH = "KEY_CURRENT_PATH";
    protected final HashSet<T> mCheckedItems = new HashSet();
    protected final HashSet<CheckableViewHolder> mCheckedVisibleViewHolders = new HashSet();
    protected int mode = 0;
    protected T mCurrentPath = null;
    protected boolean allowCreateDir = false;
    protected boolean allowMultiple = false;
    protected boolean allowExistingFile = true;
    protected boolean singleClick = false;
    protected OnFilePickedListener mListener;
    protected FileItemAdapter<T> mAdapter = null;
    protected TextView mCurrentDirView;
    protected EditText mEditTextFileName;
    protected RecyclerView recyclerView;
    protected LinearLayoutManager layoutManager;
    protected SortedList<T> mFiles = null;
    protected Toast mToast = null;
    protected boolean isLoading = false;
    protected View mNewFileButtonContainer = null;
    protected View mRegularButtonContainer = null;

    public AbstractFilePickerFragment() {
        this.setRetainInstance(true);
    }

    protected FileItemAdapter<T> getAdapter() {
        return this.mAdapter;
    }

    protected FileItemAdapter<T> getDummyAdapter() {
        return new FileItemAdapter(this);
    }

    public void setArgs(@Nullable String startPath, int mode, boolean allowMultiple, boolean allowDirCreate, boolean allowExistingFile, boolean singleClick) {
        if (mode == 3 && allowMultiple) {
            throw new IllegalArgumentException("MODE_NEW_FILE does not support 'allowMultiple'");
        }
        if (singleClick && allowMultiple) {
            throw new IllegalArgumentException("'singleClick' can not be used with 'allowMultiple'");
        }
        Bundle b = this.getArguments();
        if (b == null) {
            b = new Bundle();
        }
        if (startPath != null) {
            b.putString(KEY_START_PATH, startPath);
        }
        b.putBoolean(KEY_ALLOW_DIR_CREATE, allowDirCreate);
        b.putBoolean(KEY_ALLOW_MULTIPLE, allowMultiple);
        b.putBoolean(KEY_ALLOW_EXISTING_FILE, allowExistingFile);
        b.putBoolean(KEY_SINGLE_CLICK, singleClick);
        b.putInt(KEY_MODE, mode);
        this.setArguments(b);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.inflateRootView(inflater, container);
        Toolbar toolbar = (Toolbar)view.findViewById(R.id.nnf_picker_toolbar);
        if (toolbar != null) {
            this.setupToolbar(toolbar);
        }
        this.recyclerView = (RecyclerView)view.findViewById(16908298);
        this.recyclerView.setHasFixedSize(true);
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.configureItemDecoration(inflater, this.recyclerView);
        this.mAdapter = new FileItemAdapter(this);
        this.recyclerView.setAdapter(this.mAdapter);
        view.findViewById(R.id.nnf_button_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractFilePickerFragment.this.onClickCancel(v);
            }
        });
        view.findViewById(R.id.nnf_button_ok).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractFilePickerFragment.this.onClickOk(v);
            }
        });
        view.findViewById(R.id.nnf_button_ok_newfile).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractFilePickerFragment.this.onClickOk(v);
            }
        });
        this.mNewFileButtonContainer = view.findViewById(R.id.nnf_newfile_button_container);
        this.mRegularButtonContainer = view.findViewById(R.id.nnf_button_container);
        this.mEditTextFileName = (EditText)view.findViewById(R.id.nnf_text_filename);
        this.mEditTextFileName.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AbstractFilePickerFragment.this.clearSelections();
            }
        });
        this.mCurrentDirView = (TextView)view.findViewById(R.id.nnf_current_dir);
        if (this.mCurrentPath != null && this.mCurrentDirView != null) {
            this.mCurrentDirView.setText((CharSequence)this.getFullPath(this.mCurrentPath));
        }
        return view;
    }

    protected View inflateRootView(LayoutInflater inflater, ViewGroup container) {
        return inflater.inflate(R.layout.nnf_fragment_filepicker, container, false);
    }

    protected void configureItemDecoration(@NonNull LayoutInflater inflater, @NonNull RecyclerView recyclerView) {
        TypedArray attributes = this.getActivity().obtainStyledAttributes(new int[]{R.attr.nnf_list_item_divider});
        Drawable divider = attributes.getDrawable(0);
        attributes.recycle();
        if (divider != null) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(divider));
        }
    }

    public void onClickCancel(@NonNull View view) {
        if (this.mListener != null) {
            this.mListener.onCancelled();
        }
    }

    public void onClickOk(@NonNull View view) {
        if (this.mListener == null) {
            return;
        }
        if ((this.allowMultiple || this.mode == 0) && (this.mCheckedItems.isEmpty() || this.getFirstCheckedItem() == null)) {
            if (this.mToast == null) {
                this.mToast = Toast.makeText((Context)this.getActivity(), (int)R.string.nnf_select_something_first, (int)0);
            }
            this.mToast.show();
            return;
        }
        if (this.mode == 3) {
            String filename = this.getNewFileName();
            Uri result = filename.startsWith("/") ? this.toUri(this.getPath(filename)) : this.toUri(this.getPath(Utils.appendPath(this.getFullPath(this.mCurrentPath), filename)));
            this.mListener.onFilePicked(result);
        } else if (this.allowMultiple) {
            this.mListener.onFilesPicked(this.toUri((Iterable<T>)this.mCheckedItems));
        } else if (this.mode == 0) {
            this.mListener.onFilePicked(this.toUri(this.getFirstCheckedItem()));
        } else if (this.mode == 1) {
            this.mListener.onFilePicked(this.toUri(this.mCurrentPath));
        } else if (this.mCheckedItems.isEmpty()) {
            this.mListener.onFilePicked(this.toUri(this.mCurrentPath));
        } else {
            this.mListener.onFilePicked(this.toUri(this.getFirstCheckedItem()));
        }
    }

    @NonNull
    protected String getNewFileName() {
        return this.mEditTextFileName.getText().toString();
    }

    protected void setupToolbar(@NonNull Toolbar toolbar) {
        ((AppCompatActivity)this.getActivity()).setSupportActionBar(toolbar);
    }

    @Nullable
    public T getFirstCheckedItem() {
        Iterator<T> iterator = this.mCheckedItems.iterator();
        if (iterator.hasNext()) {
            T file = iterator.next();
            return file;
        }
        return null;
    }

    @NonNull
    protected List<Uri> toUri(@NonNull Iterable<T> files) {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (T file : files) {
            uris.add(this.toUri(file));
        }
        return uris;
    }

    public boolean isCheckable(@NonNull T data) {
        boolean checkable = this.isDir(data) ? this.mode == 1 && this.allowMultiple || this.mode == 2 && this.allowMultiple : this.mode == 0 || this.mode == 2 || this.allowExistingFile;
        return checkable;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.mListener = (OnFilePickedListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context.toString() + " must implement OnFilePickedListener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.mCurrentPath == null) {
            if (savedInstanceState != null) {
                this.mode = savedInstanceState.getInt(KEY_MODE, this.mode);
                this.allowCreateDir = savedInstanceState.getBoolean(KEY_ALLOW_DIR_CREATE, this.allowCreateDir);
                this.allowMultiple = savedInstanceState.getBoolean(KEY_ALLOW_MULTIPLE, this.allowMultiple);
                this.allowExistingFile = savedInstanceState.getBoolean(KEY_ALLOW_EXISTING_FILE, this.allowExistingFile);
                this.singleClick = savedInstanceState.getBoolean(KEY_SINGLE_CLICK, this.singleClick);
                String path = savedInstanceState.getString(KEY_CURRENT_PATH);
                if (path != null) {
                    this.mCurrentPath = this.getPath(path.trim());
                }
            } else if (this.getArguments() != null) {
                String path;
                this.mode = this.getArguments().getInt(KEY_MODE, this.mode);
                this.allowCreateDir = this.getArguments().getBoolean(KEY_ALLOW_DIR_CREATE, this.allowCreateDir);
                this.allowMultiple = this.getArguments().getBoolean(KEY_ALLOW_MULTIPLE, this.allowMultiple);
                this.allowExistingFile = this.getArguments().getBoolean(KEY_ALLOW_EXISTING_FILE, this.allowExistingFile);
                this.singleClick = this.getArguments().getBoolean(KEY_SINGLE_CLICK, this.singleClick);
                if (this.getArguments().containsKey(KEY_START_PATH) && (path = this.getArguments().getString(KEY_START_PATH)) != null) {
                    Object file = this.getPath(path.trim());
                    if (this.isDir(file)) {
                        this.mCurrentPath = file;
                    } else {
                        this.mCurrentPath = this.getParent(file);
                        this.mEditTextFileName.setText((CharSequence)this.getName(file));
                    }
                }
            }
        }
        this.setModeView();
        if (this.mCurrentPath == null) {
            this.mCurrentPath = this.getRoot();
        }
        this.refresh(this.mCurrentPath);
    }

    protected void setModeView() {
        boolean nf = this.mode == 3;
        this.mNewFileButtonContainer.setVisibility(nf ? 0 : 8);
        this.mRegularButtonContainer.setVisibility(nf ? 8 : 0);
        if (!nf && this.singleClick) {
            this.getActivity().findViewById(R.id.nnf_button_ok).setVisibility(8);
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.picker_actions, menu2);
        MenuItem item = menu2.findItem(R.id.nnf_action_createdir);
        item.setVisible(this.allowCreateDir);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (R.id.nnf_action_createdir == menuItem.getItemId()) {
            FragmentActivity activity = this.getActivity();
            if (activity instanceof AppCompatActivity) {
                NewFolderFragment.showDialog(((AppCompatActivity)activity).getSupportFragmentManager(), this);
            }
            return true;
        }
        return false;
    }

    public void onSaveInstanceState(Bundle b) {
        b.putString(KEY_CURRENT_PATH, this.mCurrentPath.toString());
        b.putBoolean(KEY_ALLOW_MULTIPLE, this.allowMultiple);
        b.putBoolean(KEY_ALLOW_EXISTING_FILE, this.allowExistingFile);
        b.putBoolean(KEY_ALLOW_DIR_CREATE, this.allowCreateDir);
        b.putBoolean(KEY_SINGLE_CLICK, this.singleClick);
        b.putInt(KEY_MODE, this.mode);
        super.onSaveInstanceState(b);
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    protected void refresh(@NonNull T nextPath) {
        if (this.hasPermission(nextPath)) {
            this.mCurrentPath = nextPath;
            this.isLoading = true;
            this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        } else {
            this.handlePermission(nextPath);
        }
    }

    protected void handlePermission(@NonNull T path) {
    }

    protected boolean hasPermission(@NonNull T path) {
        return true;
    }

    public Loader<SortedList<T>> onCreateLoader(int id2, Bundle args) {
        return this.getLoader();
    }

    public void onLoadFinished(Loader<SortedList<T>> loader, SortedList<T> data) {
        this.isLoading = false;
        this.mCheckedItems.clear();
        this.mCheckedVisibleViewHolders.clear();
        this.mFiles = data;
        this.mAdapter.setList(data);
        if (this.mCurrentDirView != null) {
            this.mCurrentDirView.setText((CharSequence)this.getFullPath(this.mCurrentPath));
        }
        this.getLoaderManager().destroyLoader(0);
    }

    public void onLoaderReset(Loader<SortedList<T>> loader) {
        this.isLoading = false;
    }

    @Override
    public int getItemViewType(int position, @NonNull T data) {
        if (this.isCheckable(data)) {
            return 2;
        }
        return 1;
    }

    @Override
    public void onBindHeaderViewHolder(@NonNull HeaderViewHolder viewHolder) {
        viewHolder.text.setText((CharSequence)"..");
    }

    @Override
    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                View v = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.nnf_filepicker_listitem_dir, parent, false);
                return new HeaderViewHolder(v);
            }
            case 2: {
                View v = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.nnf_filepicker_listitem_checkable, parent, false);
                return new CheckableViewHolder(v);
            }
        }
        View v = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.nnf_filepicker_listitem_dir, parent, false);
        return new DirViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull DirViewHolder vh, int position, @NonNull T data) {
        vh.file = data;
        vh.icon.setVisibility(this.isDir(data) ? 0 : 8);
        vh.text.setText((CharSequence)this.getName(data));
        if (this.isCheckable(data)) {
            if (this.mCheckedItems.contains(data)) {
                this.mCheckedVisibleViewHolders.add((CheckableViewHolder)vh);
                ((CheckableViewHolder)vh).checkbox.setChecked(true);
            } else {
                this.mCheckedVisibleViewHolders.remove((Object)vh);
                ((CheckableViewHolder)vh).checkbox.setChecked(false);
            }
        }
    }

    public void clearSelections() {
        for (CheckableViewHolder vh : this.mCheckedVisibleViewHolders) {
            vh.checkbox.setChecked(false);
        }
        this.mCheckedVisibleViewHolders.clear();
        this.mCheckedItems.clear();
    }

    public void onClickHeader(@NonNull View view, @NonNull HeaderViewHolder viewHolder) {
        this.goUp();
    }

    public void goUp() {
        this.goToDir(this.getParent(this.mCurrentPath));
    }

    public void onClickDir(@NonNull View view, @NonNull DirViewHolder viewHolder) {
        if (this.isDir(viewHolder.file)) {
            this.goToDir(viewHolder.file);
        }
    }

    protected boolean isItemVisible(T file) {
        return this.isDir(file) || this.mode == 0 || this.mode == 2 || this.mode == 3 && this.allowExistingFile;
    }

    public void goToDir(@NonNull T file) {
        if (!this.isLoading) {
            this.mCheckedItems.clear();
            this.mCheckedVisibleViewHolders.clear();
            this.refresh(file);
        }
    }

    public boolean onLongClickDir(@NonNull View view, @NonNull DirViewHolder viewHolder) {
        return false;
    }

    public void onClickCheckable(@NonNull View view, @NonNull CheckableViewHolder viewHolder) {
        if (this.isDir(viewHolder.file)) {
            this.goToDir(viewHolder.file);
        } else {
            this.onLongClickCheckable(view, viewHolder);
            if (this.singleClick) {
                this.onClickOk(view);
            }
        }
    }

    public boolean onLongClickCheckable(@NonNull View view, @NonNull CheckableViewHolder viewHolder) {
        if (3 == this.mode) {
            this.mEditTextFileName.setText((CharSequence)this.getName(viewHolder.file));
        }
        this.onClickCheckBox(viewHolder);
        return true;
    }

    public void onClickCheckBox(@NonNull CheckableViewHolder viewHolder) {
        if (this.mCheckedItems.contains(viewHolder.file)) {
            viewHolder.checkbox.setChecked(false);
            this.mCheckedItems.remove(viewHolder.file);
            this.mCheckedVisibleViewHolders.remove((Object)viewHolder);
        } else {
            if (!this.allowMultiple) {
                this.clearSelections();
            }
            viewHolder.checkbox.setChecked(true);
            this.mCheckedItems.add(viewHolder.file);
            this.mCheckedVisibleViewHolders.add(viewHolder);
        }
    }

    public class CheckableViewHolder
    extends DirViewHolder {
        public CheckBox checkbox;

        public CheckableViewHolder(View v) {
            super(v);
            boolean nf = AbstractFilePickerFragment.this.mode == 3;
            this.checkbox = (CheckBox)v.findViewById(R.id.checkbox);
            this.checkbox.setVisibility(nf || AbstractFilePickerFragment.this.singleClick ? 8 : 0);
            this.checkbox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbstractFilePickerFragment.this.onClickCheckBox(CheckableViewHolder.this);
                }
            });
        }

        @Override
        public void onClick(View v) {
            AbstractFilePickerFragment.this.onClickCheckable(v, this);
        }

        @Override
        public boolean onLongClick(View v) {
            return AbstractFilePickerFragment.this.onLongClickCheckable(v, this);
        }
    }

    public class DirViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        public View icon;
        public TextView text;
        public T file;

        public DirViewHolder(View v) {
            super(v);
            v.setOnClickListener((View.OnClickListener)this);
            v.setOnLongClickListener((View.OnLongClickListener)this);
            this.icon = v.findViewById(R.id.item_icon);
            this.text = (TextView)v.findViewById(16908308);
        }

        public void onClick(View v) {
            AbstractFilePickerFragment.this.onClickDir(v, this);
        }

        public boolean onLongClick(View v) {
            return AbstractFilePickerFragment.this.onLongClickDir(v, this);
        }
    }

    public class HeaderViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        final TextView text;

        public HeaderViewHolder(View v) {
            super(v);
            v.setOnClickListener((View.OnClickListener)this);
            this.text = (TextView)v.findViewById(16908308);
        }

        public void onClick(View v) {
            AbstractFilePickerFragment.this.onClickHeader(v, this);
        }
    }

    public static interface OnFilePickedListener {
        public void onFilePicked(@NonNull Uri var1);

        public void onFilesPicked(@NonNull List<Uri> var1);

        public void onCancelled();
    }
}

