/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.content.Context;
import android.net.Uri;
import android.os.FileObserver;
import android.support.annotation.NonNull;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v4.content.Loader;
import android.support.v7.util.SortedList;
import android.support.v7.widget.util.SortedListAdapterCallback;
import android.widget.Toast;
import com.nononsenseapps.filepicker.AbstractFilePickerFragment;
import com.nononsenseapps.filepicker.R;
import java.io.File;

public class FilePickerFragment
extends AbstractFilePickerFragment<File> {
    protected static final int PERMISSIONS_REQUEST_WRITE_EXTERNAL_STORAGE = 1;
    protected boolean showHiddenItems = false;
    private File mRequestedPath = null;

    public void showHiddenItems(boolean showHiddenItems) {
        this.showHiddenItems = showHiddenItems;
    }

    public boolean areHiddenItemsShown() {
        return this.showHiddenItems;
    }

    @Override
    protected boolean hasPermission(@NonNull File path) {
        return 0 == ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE");
    }

    @Override
    protected void handlePermission(@NonNull File path) {
        this.mRequestedPath = path;
        this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (permissions.length == 0) {
            if (this.mListener != null) {
                this.mListener.onCancelled();
            }
        } else if (0 == grantResults[0]) {
            if (this.mRequestedPath != null) {
                this.refresh(this.mRequestedPath);
            }
        } else {
            Toast.makeText((Context)this.getContext(), (int)R.string.nnf_permission_external_write_denied, (int)0).show();
            if (this.mListener != null) {
                this.mListener.onCancelled();
            }
        }
    }

    @Override
    public boolean isDir(@NonNull File path) {
        return path.isDirectory();
    }

    @Override
    @NonNull
    public String getName(@NonNull File path) {
        return path.getName();
    }

    @Override
    @NonNull
    public File getParent(@NonNull File from) {
        if (from.getPath().equals(this.getRoot().getPath())) {
            return from;
        }
        if (from.getParentFile() != null) {
            return from.getParentFile();
        }
        return from;
    }

    @Override
    @NonNull
    public File getPath(@NonNull String path) {
        return new File(path);
    }

    @Override
    @NonNull
    public String getFullPath(@NonNull File path) {
        return path.getPath();
    }

    @Override
    @NonNull
    public File getRoot() {
        return new File("/");
    }

    @Override
    @NonNull
    public Uri toUri(@NonNull File file) {
        return FileProvider.getUriForFile((Context)this.getContext(), (String)(this.getContext().getApplicationContext().getPackageName() + ".provider"), (File)file);
    }

    @Override
    @NonNull
    public Loader<SortedList<File>> getLoader() {
        return new AsyncTaskLoader<SortedList<File>>((Context)this.getActivity()){
            FileObserver fileObserver;

            public SortedList<File> loadInBackground() {
                File[] listFiles = ((File)FilePickerFragment.this.mCurrentPath).listFiles();
                int initCap = listFiles == null ? 0 : listFiles.length;
                SortedList files = new SortedList(File.class, (SortedList.Callback)new SortedListAdapterCallback<File>(FilePickerFragment.this.getDummyAdapter()){

                    public int compare(File lhs, File rhs) {
                        return FilePickerFragment.this.compareFiles(lhs, rhs);
                    }

                    public boolean areContentsTheSame(File file, File file2) {
                        return file.getAbsolutePath().equals(file2.getAbsolutePath()) && file.isFile() == file2.isFile();
                    }

                    public boolean areItemsTheSame(File file, File file2) {
                        return this.areContentsTheSame(file, file2);
                    }
                }, initCap);
                files.beginBatchedUpdates();
                if (listFiles != null) {
                    for (File f : listFiles) {
                        if (!FilePickerFragment.this.isItemVisible(f)) continue;
                        files.add((Object)f);
                    }
                }
                files.endBatchedUpdates();
                return files;
            }

            protected void onStartLoading() {
                super.onStartLoading();
                if (FilePickerFragment.this.mCurrentPath == null || !((File)FilePickerFragment.this.mCurrentPath).isDirectory()) {
                    FilePickerFragment.this.mCurrentPath = FilePickerFragment.this.getRoot();
                }
                this.fileObserver = new FileObserver(((File)FilePickerFragment.this.mCurrentPath).getPath(), 960){

                    public void onEvent(int event, String path) {
                        this.onContentChanged();
                    }
                };
                this.fileObserver.startWatching();
                this.forceLoad();
            }

            protected void onReset() {
                super.onReset();
                if (this.fileObserver != null) {
                    this.fileObserver.stopWatching();
                    this.fileObserver = null;
                }
            }
        };
    }

    @Override
    public void onNewFolder(@NonNull String name) {
        File folder = new File((File)this.mCurrentPath, name);
        if (folder.mkdir()) {
            this.refresh(folder);
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.nnf_create_folder_error, (int)0).show();
        }
    }

    @Override
    protected boolean isItemVisible(File file) {
        if (!this.showHiddenItems && file.isHidden()) {
            return false;
        }
        return super.isItemVisible(file);
    }

    protected int compareFiles(@NonNull File lhs, @NonNull File rhs) {
        if (lhs.isDirectory() && !rhs.isDirectory()) {
            return -1;
        }
        if (rhs.isDirectory() && !lhs.isDirectory()) {
            return 1;
        }
        return lhs.getName().compareToIgnoreCase(rhs.getName());
    }
}

