/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import com.nononsenseapps.filepicker.R;

public abstract class NewItemFragment
extends DialogFragment {
    private OnNewFolderListener listener = null;

    public void setListener(@Nullable OnNewFolderListener listener) {
        this.listener = listener;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setView(R.layout.nnf_dialog_folder_name).setTitle(R.string.nnf_new_folder).setNegativeButton(R.string.nnf_new_folder_cancel, null).setPositiveButton(R.string.nnf_new_folder_ok, null);
        AlertDialog dialog = builder.create();
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog1) {
                final AlertDialog dialog = (AlertDialog)dialog1;
                final EditText editText = (EditText)dialog.findViewById(R.id.edit_text);
                if (editText == null) {
                    throw new NullPointerException("Could not find an edit text in the dialog");
                }
                Button cancel = dialog.getButton(-2);
                cancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        dialog.cancel();
                    }
                });
                final Button ok = dialog.getButton(-1);
                ok.setEnabled(false);
                ok.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        String itemName = editText.getText().toString();
                        if (NewItemFragment.this.validateName(itemName)) {
                            if (NewItemFragment.this.listener != null) {
                                NewItemFragment.this.listener.onNewFolder(itemName);
                            }
                            dialog.dismiss();
                        }
                    }
                });
                editText.addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    }

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                    }

                    public void afterTextChanged(Editable s) {
                        ok.setEnabled(NewItemFragment.this.validateName(s.toString()));
                    }
                });
            }
        });
        return dialog;
    }

    protected abstract boolean validateName(String var1);

    public static interface OnNewFolderListener {
        public void onNewFolder(@NonNull String var1);
    }
}

