package spoiwo.model

object Color {

  lazy val Black: Color = Color(0, 0, 0)
  lazy val White: Color = Color(255, 255, 255)
  lazy val Red: Color = Color(255, 0, 0)
  lazy val Lime: Color = Color(0, 255, 0)
  lazy val Blue: Color = Color(0, 0, 255)
  lazy val Yellow: Color = Color(255, 255, 0)
  lazy val Aqua: Color = Color(0, 255, 255)
  lazy val Magenta: Color = Color(255, 0, 255)
  lazy val Silver: Color = Color(192, 192, 192)
  lazy val Gray: Color = Color(128, 128, 128)
  lazy val Maroon: Color = Color(128, 0, 0)
  lazy val Olive: Color = Color(128, 128, 0)
  lazy val Green: Color = Color(0, 128, 0)
  lazy val Purple: Color = Color(128, 0, 128)
  lazy val Teal: Color = Color(0, 128, 128)
  lazy val Navy: Color = Color(0, 0, 128)
  lazy val Orange: Color = Color(255, 165, 0)
  lazy val DarkRed: Color = Color(139, 0, 0)
  lazy val Brown: Color = Color(165, 42, 42)
  lazy val Firebrick: Color = Color(178, 34, 34)
  lazy val Crimson: Color = Color(220, 20, 60)
  lazy val Tomato: Color = Color(255, 99, 71)
  lazy val Coral: Color = Color(255, 127, 80)
  lazy val IndianRed: Color = Color(205, 92, 92)
  lazy val LightCoral: Color = Color(240, 128, 128)
  lazy val DarkSalmon: Color = Color(233, 150, 122)
  lazy val Salmon: Color = Color(250, 128, 114)
  lazy val LightSalmon: Color = Color(255, 160, 122)
  lazy val OrangeRed: Color = Color(255, 69, 0)
  lazy val DarkOrange: Color = Color(255, 140, 0)
  lazy val Gold: Color = Color(255, 215, 0)
  lazy val DarkGoldenRod: Color = Color(184, 134, 11)
  lazy val GoldenRod: Color = Color(218, 165, 32)
  lazy val PaleGoldenRod: Color = Color(238, 232, 170)
  lazy val DarkKhaki: Color = Color(189, 183, 107)
  lazy val Khaki: Color = Color(240, 230, 140)
  lazy val YellowGreen: Color = Color(154, 205, 50)
  lazy val DarkOliveGreen: Color = Color(85, 107, 47)
  lazy val OliveDrab: Color = Color(107, 142, 35)
  lazy val LawnGreen: Color = Color(124, 252, 0)
  lazy val ChartReuse: Color = Color(127, 255, 0)
  lazy val GreenYellow: Color = Color(173, 255, 47)
  lazy val DarkGreen: Color = Color(0, 100, 0)
  lazy val ForestGreen: Color = Color(34, 139, 34)
  lazy val LimeGreen: Color = Color(50, 205, 50)
  lazy val LightGreen: Color = Color(144, 238, 144)
  lazy val PaleGreen: Color = Color(152, 251, 152)
  lazy val DarkSeaGreen: Color = Color(143, 188, 143)
  lazy val MediumSpringGreen: Color = Color(0, 250, 154)
  lazy val SpringGreen: Color = Color(0, 255, 127)
  lazy val SeaGreen: Color = Color(46, 139, 87)
  lazy val MediumAquaMarine: Color = Color(102, 205, 170)
  lazy val MediumSeaGreen: Color = Color(60, 179, 113)
  lazy val LightSeaGreen: Color = Color(32, 178, 170)
  lazy val DarkSlateGray: Color = Color(47, 79, 79)
  lazy val DarkCyan: Color = Color(0, 139, 139)
  lazy val Cyan: Color = Color(0, 255, 255)
  lazy val LightCyan: Color = Color(224, 255, 255)
  lazy val DarkTurquoise: Color = Color(0, 206, 209)
  lazy val Turquoise: Color = Color(64, 224, 208)
  lazy val MediumTurquoise: Color = Color(72, 209, 204)
  lazy val PaleTurquoise: Color = Color(175, 238, 238)
  lazy val AquaMarine: Color = Color(127, 255, 212)
  lazy val PowderBlue: Color = Color(176, 224, 230)
  lazy val CadetBlue: Color = Color(95, 158, 160)
  lazy val SteelBlue: Color = Color(70, 130, 180)
  lazy val CornFlowerBlue: Color = Color(100, 149, 237)
  lazy val DeepSkyBlue: Color = Color(0, 191, 255)
  lazy val DodgerBlue: Color = Color(30, 144, 255)
  lazy val LightBlue: Color = Color(173, 216, 230)
  lazy val SkyBlue: Color = Color(135, 206, 235)
  lazy val LightSkyBlue: Color = Color(135, 206, 250)
  lazy val MidnightBlue: Color = Color(25, 25, 112)
  lazy val DarkBlue: Color = Color(0, 0, 139)
  lazy val MediumBlue: Color = Color(0, 0, 205)
  lazy val RoyalBlue: Color = Color(65, 105, 225)
  lazy val BlueViolet: Color = Color(138, 43, 226)
  lazy val Indigo: Color = Color(75, 0, 130)
  lazy val DarkSlateBlue: Color = Color(72, 61, 139)
  lazy val SlateBlue: Color = Color(106, 90, 205)
  lazy val MediumSlateBlue: Color = Color(123, 104, 238)
  lazy val MediumPurple: Color = Color(147, 112, 219)
  lazy val DarkMagenta: Color = Color(139, 0, 139)
  lazy val DarkViolet: Color = Color(148, 0, 211)
  lazy val DarkOrchid: Color = Color(153, 50, 204)
  lazy val MediumOrchid: Color = Color(186, 85, 211)
  lazy val Thistle: Color = Color(216, 191, 216)
  lazy val Plum: Color = Color(221, 160, 221)
  lazy val Violet: Color = Color(238, 130, 238)
  lazy val Orchid: Color = Color(218, 112, 214)
  lazy val MediumVioletRed: Color = Color(199, 21, 133)
  lazy val PaleVioletRed: Color = Color(219, 112, 147)
  lazy val DeepPink: Color = Color(255, 20, 147)
  lazy val HotPink: Color = Color(255, 105, 180)
  lazy val LightPink: Color = Color(255, 182, 193)
  lazy val Pink: Color = Color(255, 192, 203)
  lazy val AntiqueWhite: Color = Color(250, 235, 215)
  lazy val Beige: Color = Color(245, 245, 220)
  lazy val Bisque: Color = Color(255, 228, 196)
  lazy val BlanchedAlmond: Color = Color(255, 235, 205)
  lazy val Wheat: Color = Color(245, 222, 179)
  lazy val CornSilk: Color = Color(255, 248, 220)
  lazy val LemonChiffon: Color = Color(255, 250, 205)
  lazy val LightGoldenRodYellow: Color = Color(250, 250, 210)
  lazy val LightYellow: Color = Color(255, 255, 224)
  lazy val SaddleBrown: Color = Color(139, 69, 19)
  lazy val Sienna: Color = Color(160, 82, 45)
  lazy val Chocolate: Color = Color(210, 105, 30)
  lazy val Peru: Color = Color(205, 133, 63)
  lazy val SandyBrown: Color = Color(244, 164, 96)
  lazy val BurlyWood: Color = Color(222, 184, 135)
  lazy val Tan: Color = Color(210, 180, 140)
  lazy val RosyBrown: Color = Color(188, 143, 143)
  lazy val Moccasin: Color = Color(255, 228, 181)
  lazy val NavajoWhite: Color = Color(255, 222, 173)
  lazy val PeachPuff: Color = Color(255, 218, 185)
  lazy val MistyRose: Color = Color(255, 228, 225)
  lazy val LavenderBlush: Color = Color(255, 240, 245)
  lazy val Linen: Color = Color(250, 240, 230)
  lazy val OldLace: Color = Color(253, 245, 230)
  lazy val PapayaWhip: Color = Color(255, 239, 213)
  lazy val SeaShell: Color = Color(255, 245, 238)
  lazy val MintCream: Color = Color(245, 255, 250)
  lazy val SlateGray: Color = Color(112, 128, 144)
  lazy val LightSlateGray: Color = Color(119, 136, 153)
  lazy val LightSteelBlue: Color = Color(176, 196, 222)
  lazy val Lavender: Color = Color(230, 230, 250)
  lazy val FloralWhite: Color = Color(255, 250, 240)
  lazy val AliceBlue: Color = Color(240, 248, 255)
  lazy val GhostWhite: Color = Color(248, 248, 255)
  lazy val Honeydew: Color = Color(240, 255, 240)
  lazy val Ivory: Color = Color(255, 255, 240)
  lazy val Azure: Color = Color(240, 255, 255)
  lazy val Snow: Color = Color(255, 250, 250)
  lazy val DimGrey: Color = Color(105, 105, 105)
  lazy val Grey: Color = Color(128, 128, 128)
  lazy val DarkGrey: Color = Color(169, 169, 169)
  lazy val LightGrey: Color = Color(211, 211, 211)
  lazy val Gainsborough: Color = Color(220, 220, 220)
  lazy val WhiteSmoke: Color = Color(245, 245, 245)

  def apply(rgbArray: Array[Byte]): Color = {
    require(rgbArray.length == 3, "Only 3 values are allowed in RGB array!")
    Color(rgbArray(0), rgbArray(1), rgbArray(2))
  }
}

case class Color(r: Int, g: Int, b: Int) {
  require(r >= 0 && r <= 255, "Invalid red color value = %d".format(r))
  require(g >= 0 && g <= 255, "Invalid green color value = %d".format(g))
  require(b >= 0 && b <= 255, "Invalid blue color value = %d".format(b))
}
