/*
 * Decompiled with CFR 0.152.
 */
package spoiwo.natures.csv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVWriter;
import com.github.tototoshi.csv.CSVWriter$;
import com.github.tototoshi.csv.DefaultCSVFormat;
import com.github.tototoshi.csv.Quoting;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.time.ZoneId;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import spoiwo.model.BlankCell;
import spoiwo.model.BooleanCell;
import spoiwo.model.CalendarCell;
import spoiwo.model.Cell;
import spoiwo.model.DateCell;
import spoiwo.model.HyperLinkCell;
import spoiwo.model.NumericCell;
import spoiwo.model.Sheet;
import spoiwo.model.StringCell;
import spoiwo.model.Workbook;
import spoiwo.natures.csv.CsvProperties;
import spoiwo.natures.csv.Model2CsvConversions;

public final class Model2CsvConversions$ {
    public static Model2CsvConversions$ MODULE$;

    static {
        new Model2CsvConversions$();
    }

    public Model2CsvConversions.CsvWorkbook CsvWorkbook(Workbook wb) {
        return new Model2CsvConversions.CsvWorkbook(wb);
    }

    public Model2CsvConversions.CsvSheet CsvSheet(Sheet s) {
        return new Model2CsvConversions.CsvSheet(s);
    }

    public Map<String, String> spoiwo$natures$csv$Model2CsvConversions$$convertWorkbookToCsv(Workbook wb, CsvProperties properties) {
        Predef$.MODULE$.require(wb.sheets().size() <= 1 || wb.sheets().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Model2CsvConversions$.$anonfun$convertWorkbookToCsv$1(x$1))), (Function0 & Serializable & scala.Serializable)() -> "When converting workbook with multiple sheets to CSV format it is required to specify the unique name for each of them!");
        return ((TraversableOnce)wb.sheets().map((Function1 & Serializable & scala.Serializable)s -> MODULE$.spoiwo$natures$csv$Model2CsvConversions$$convertSheetToCsv((Sheet)s, properties), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<String, String> spoiwo$natures$csv$Model2CsvConversions$$convertSheetToCsv(Sheet s, CsvProperties properties) {
        DefaultCSVFormat format = new DefaultCSVFormat(properties){
            private final char delimiter;
            private final String lineTerminator;
            private final char quoteChar;
            private final char escapeChar;
            private final Quoting quoting;
            private final boolean treatEmptyLineAsNil;

            public char quoteChar() {
                return this.quoteChar;
            }

            public char escapeChar() {
                return this.escapeChar;
            }

            public Quoting quoting() {
                return this.quoting;
            }

            public boolean treatEmptyLineAsNil() {
                return this.treatEmptyLineAsNil;
            }

            public void com$github$tototoshi$csv$DefaultCSVFormat$_setter_$delimiter_$eq(char x$1) {
            }

            public void com$github$tototoshi$csv$DefaultCSVFormat$_setter_$quoteChar_$eq(char x$1) {
                this.quoteChar = x$1;
            }

            public void com$github$tototoshi$csv$DefaultCSVFormat$_setter_$escapeChar_$eq(char x$1) {
                this.escapeChar = x$1;
            }

            public void com$github$tototoshi$csv$DefaultCSVFormat$_setter_$lineTerminator_$eq(String x$1) {
            }

            public void com$github$tototoshi$csv$DefaultCSVFormat$_setter_$quoting_$eq(Quoting x$1) {
                this.quoting = x$1;
            }

            public void com$github$tototoshi$csv$DefaultCSVFormat$_setter_$treatEmptyLineAsNil_$eq(boolean x$1) {
                this.treatEmptyLineAsNil = x$1;
            }

            public char delimiter() {
                return this.delimiter;
            }

            public String lineTerminator() {
                return this.lineTerminator;
            }
            {
                DefaultCSVFormat.$init$((DefaultCSVFormat)this);
                this.delimiter = properties$2.separator();
                this.lineTerminator = "\n";
            }
        };
        try (StringWriter sw = new StringWriter();
             CSVWriter csvWriter = CSVWriter$.MODULE$.open((Writer)sw, (CSVFormat)format);){
            List allRows = (List)s.rows().map((Function1 & Serializable & scala.Serializable)r -> ((TraversableOnce)r.cells().map((Function1 & Serializable & scala.Serializable)c -> MODULE$.convertCellToCsv((Cell)c, properties), Iterable$.MODULE$.canBuildFrom())).toSeq(), List$.MODULE$.canBuildFrom());
            csvWriter.writeAll((Seq)allRows);
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (Object)sw.toString());
    }

    private String convertCellToCsv(Cell c, CsvProperties properties) {
        String string;
        Cell cell = c;
        if (cell instanceof BlankCell) {
            string = "";
        } else if (cell instanceof StringCell) {
            StringCell stringCell = (StringCell)cell;
            string = stringCell.value();
        } else if (cell instanceof NumericCell) {
            NumericCell numericCell = (NumericCell)cell;
            string = Double.toString(numericCell.value());
        } else if (cell instanceof BooleanCell) {
            BooleanCell booleanCell = (BooleanCell)cell;
            string = booleanCell.value() ? properties.defaultBooleanTrueString() : properties.defaultBooleanFalseString();
        } else if (cell instanceof DateCell) {
            DateCell dateCell = (DateCell)cell;
            string = dateCell.value().toInstant().atZone(ZoneId.systemDefault()).format(properties.defaultDateFormatter());
        } else if (cell instanceof CalendarCell) {
            CalendarCell calendarCell = (CalendarCell)cell;
            string = calendarCell.value().toInstant().atZone(ZoneId.systemDefault()).format(properties.defaultDateFormatter());
        } else if (cell instanceof HyperLinkCell) {
            HyperLinkCell hyperLinkCell = (HyperLinkCell)cell;
            string = hyperLinkCell.value().text();
        } else {
            throw new IllegalArgumentException(new StringBuilder(42).append("Unable to convert to CSV cell for value: ").append(cell).append("!").toString());
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$convertWorkbookToCsv$1(Sheet x$1) {
        return x$1.name().isDefined();
    }

    private Model2CsvConversions$() {
        MODULE$ = this;
    }
}

