/*
 * Decompiled with CFR 0.152.
 */
package spoiwo.natures.xlsx;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPrintSetup;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumns;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyleInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import spoiwo.model.BlankCell;
import spoiwo.model.BooleanCell;
import spoiwo.model.CalendarCell;
import spoiwo.model.Cell;
import spoiwo.model.CellBorders;
import spoiwo.model.CellDataFormat;
import spoiwo.model.CellRange;
import spoiwo.model.Color;
import spoiwo.model.Column;
import spoiwo.model.ColumnRange;
import spoiwo.model.DateCell;
import spoiwo.model.Font;
import spoiwo.model.FormulaCell;
import spoiwo.model.HyperLink;
import spoiwo.model.HyperLinkCell;
import spoiwo.model.Image;
import spoiwo.model.Margins;
import spoiwo.model.NumericCell;
import spoiwo.model.PaneAction;
import spoiwo.model.PrintSetup;
import spoiwo.model.PrintSetup$;
import spoiwo.model.Row;
import spoiwo.model.RowRange;
import spoiwo.model.SheetLocking;
import spoiwo.model.SheetProperties;
import spoiwo.model.StringCell;
import spoiwo.model.Table;
import spoiwo.model.TableColumn;
import spoiwo.model.TableStyle;
import spoiwo.model.Workbook;
import spoiwo.model.enums.CellBorderStyle;
import spoiwo.model.enums.CellFill;
import spoiwo.model.enums.CellHorizontalAlignment;
import spoiwo.model.enums.CellReadingOrder;
import spoiwo.model.enums.CellVerticalAlignment;
import spoiwo.model.enums.Pane;
import spoiwo.natures.xlsx.BaseXlsx;
import spoiwo.natures.xlsx.Model2XlsxConversions;
import spoiwo.natures.xlsx.Model2XlsxEnumConversions$;

public final class Model2XlsxConversions$
implements BaseXlsx {
    public static final Model2XlsxConversions$ MODULE$ = new Model2XlsxConversions$();
    private static Map<XSSFWorkbook, Map<spoiwo.model.CellStyle, XSSFCellStyle>> cellStyleCache;
    private static Map<XSSFWorkbook, XSSFDataFormat> dataFormatCache;
    private static Map<XSSFWorkbook, Map<Font, XSSFFont>> fontCache;
    private static LocalDate spoiwo$natures$xlsx$BaseXlsx$$FirstSupportedDate;
    private static LocalDate spoiwo$natures$xlsx$BaseXlsx$$LastSupportedDate;
    private static volatile byte bitmap$0;

    static {
        BaseXlsx.$init$(MODULE$);
    }

    @Override
    public Cell mergeStyle(Cell cell, Option<spoiwo.model.CellStyle> rowStyle, Option<spoiwo.model.CellStyle> columnStyle, Option<spoiwo.model.CellStyle> sheetStyle) {
        return BaseXlsx.mergeStyle$(this, cell, rowStyle, columnStyle, sheetStyle);
    }

    @Override
    public void convertColumn(Column c, Sheet sheet) {
        BaseXlsx.convertColumn$(this, c, sheet);
    }

    @Override
    public void convertCellBorders(CellBorders borders, XSSFCellStyle style) {
        BaseXlsx.convertCellBorders$(this, borders, style);
    }

    @Override
    public XSSFColor convertColor(Color color) {
        return BaseXlsx.convertColor$(this, color);
    }

    @Override
    public void setHyperLinkCell(org.apache.poi.ss.usermodel.Cell cell, HyperLink value, org.apache.poi.ss.usermodel.Row row) {
        BaseXlsx.setHyperLinkCell$(this, cell, value, row);
    }

    @Override
    public CellRangeAddress convertCellRange(CellRange cr) {
        return BaseXlsx.convertCellRange$(this, cr);
    }

    @Override
    public XSSFFont convertFont(Font f, XSSFFont font) {
        return BaseXlsx.convertFont$(this, f, font);
    }

    @Override
    public void validateCells(Row r) {
        BaseXlsx.validateCells$(this, r);
    }

    @Override
    public void validateRows(spoiwo.model.Sheet s) {
        BaseXlsx.validateRows$(this, s);
    }

    @Override
    public List<Column> updateColumnsWithIndexes(spoiwo.model.Sheet s) {
        return BaseXlsx.updateColumnsWithIndexes$(this, s);
    }

    @Override
    public void convertSheetProperties(SheetProperties sp2, Sheet sheet) {
        BaseXlsx.convertSheetProperties$(this, sp2, sheet);
    }

    @Override
    public void convertSheetLocking(SheetLocking sl, XSSFSheet sheet) {
        BaseXlsx.convertSheetLocking$(this, sl, sheet);
    }

    @Override
    public void convertPrintSetup(PrintSetup printSetup, Sheet sheet) {
        BaseXlsx.convertPrintSetup$(this, printSetup, sheet);
    }

    @Override
    public CellRangeAddress convertRowRange(RowRange rr) {
        return BaseXlsx.convertRowRange$(this, rr);
    }

    @Override
    public CellRangeAddress convertColumnRange(ColumnRange cr) {
        return BaseXlsx.convertColumnRange$(this, cr);
    }

    @Override
    public void setDateCell(Cell c, org.apache.poi.ss.usermodel.Cell cell, Date value) {
        BaseXlsx.setDateCell$(this, c, cell, value);
    }

    @Override
    public void setCalendarCell(Cell c, org.apache.poi.ss.usermodel.Cell cell, Calendar value) {
        BaseXlsx.setCalendarCell$(this, c, cell, value);
    }

    @Override
    public int convertPane(Pane pane) {
        return BaseXlsx.convertPane$(this, pane);
    }

    @Override
    public void convertPaneAction(PaneAction paneAction, Sheet sheet) {
        BaseXlsx.convertPaneAction$(this, paneAction, sheet);
    }

    @Override
    public void convertMargins(Margins margins, Sheet sheet) {
        BaseXlsx.convertMargins$(this, margins, sheet);
    }

    @Override
    public LocalDate spoiwo$natures$xlsx$BaseXlsx$$FirstSupportedDate() {
        return spoiwo$natures$xlsx$BaseXlsx$$FirstSupportedDate;
    }

    @Override
    public LocalDate spoiwo$natures$xlsx$BaseXlsx$$LastSupportedDate() {
        return spoiwo$natures$xlsx$BaseXlsx$$LastSupportedDate;
    }

    @Override
    public final void spoiwo$natures$xlsx$BaseXlsx$_setter_$spoiwo$natures$xlsx$BaseXlsx$$FirstSupportedDate_$eq(LocalDate x$1) {
        spoiwo$natures$xlsx$BaseXlsx$$FirstSupportedDate = x$1;
    }

    @Override
    public final void spoiwo$natures$xlsx$BaseXlsx$_setter_$spoiwo$natures$xlsx$BaseXlsx$$LastSupportedDate_$eq(LocalDate x$1) {
        spoiwo$natures$xlsx$BaseXlsx$$LastSupportedDate = x$1;
    }

    private Map<XSSFWorkbook, Map<spoiwo.model.CellStyle, XSSFCellStyle>> cellStyleCache$lzycompute() {
        Model2XlsxConversions$ model2XlsxConversions$ = this;
        synchronized (model2XlsxConversions$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                cellStyleCache = this.Cache();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return cellStyleCache;
    }

    private Map<XSSFWorkbook, Map<spoiwo.model.CellStyle, XSSFCellStyle>> cellStyleCache() {
        return (byte)(bitmap$0 & 1) == 0 ? this.cellStyleCache$lzycompute() : cellStyleCache;
    }

    private Map<XSSFWorkbook, XSSFDataFormat> dataFormatCache$lzycompute() {
        Model2XlsxConversions$ model2XlsxConversions$ = this;
        synchronized (model2XlsxConversions$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                dataFormatCache = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return dataFormatCache;
    }

    private Map<XSSFWorkbook, XSSFDataFormat> dataFormatCache() {
        return (byte)(bitmap$0 & 2) == 0 ? this.dataFormatCache$lzycompute() : dataFormatCache;
    }

    private Map<XSSFWorkbook, Map<Font, XSSFFont>> fontCache$lzycompute() {
        Model2XlsxConversions$ model2XlsxConversions$ = this;
        synchronized (model2XlsxConversions$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                fontCache = this.Cache();
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return fontCache;
    }

    private Map<XSSFWorkbook, Map<Font, XSSFFont>> fontCache() {
        return (byte)(bitmap$0 & 4) == 0 ? this.fontCache$lzycompute() : fontCache;
    }

    private <K, V> Map<XSSFWorkbook, Map<K, V>> Cache() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public XSSFCell convertCell(spoiwo.model.Sheet modelSheet, scala.collection.immutable.Map<Object, Column> modelColumns, Row modelRow, Cell c, XSSFRow row) {
        int cellNumber = BoxesRunTime.unboxToInt((Object)c.index().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> row.getLastCellNum() < 0 ? (short)0 : row.getLastCellNum()));
        XSSFCell cell = (XSSFCell)Option$.MODULE$.apply((Object)row.getCell(cellNumber)).getOrElse((Function0 & Serializable)() -> row.createCell(cellNumber));
        CellType cellType = cell.getCellType();
        CellType cellType2 = CellType.FORMULA;
        if (!(cellType != null ? !cellType.equals(cellType2) : cellType2 != null)) {
            cell.setCellFormula(null);
        }
        Cell cellWithStyle = this.mergeStyle(c, modelRow.style(), (Option<spoiwo.model.CellStyle>)modelColumns.get((Object)BoxesRunTime.boxToInteger((int)cellNumber)).flatMap((Function1 & Serializable)x$1 -> x$1.style()), modelSheet.style());
        cellWithStyle.style().foreach((Function1 & Serializable)s -> {
            cell.setCellStyle((CellStyle)Model2XlsxConversions$.MODULE$.convertCellStyle(s, cell.getRow().getSheet().getWorkbook()));
            return BoxedUnit.UNIT;
        });
        Cell cell2 = c;
        if (cell2 instanceof BlankCell) {
            cell.setCellValue(null);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cell2 instanceof StringCell) {
            StringCell stringCell = (StringCell)cell2;
            String value = stringCell.value();
            cell.setCellValue(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cell2 instanceof FormulaCell) {
            FormulaCell formulaCell = (FormulaCell)cell2;
            String formula = formulaCell.value();
            cell.setCellFormula(formula);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cell2 instanceof NumericCell) {
            NumericCell numericCell = (NumericCell)cell2;
            double value = numericCell.value();
            cell.setCellValue(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cell2 instanceof BooleanCell) {
            BooleanCell booleanCell = (BooleanCell)cell2;
            boolean value = booleanCell.value();
            cell.setCellValue(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cell2 instanceof DateCell) {
            DateCell dateCell = (DateCell)cell2;
            Date value = dateCell.value();
            this.setDateCell(c, (org.apache.poi.ss.usermodel.Cell)cell, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cell2 instanceof CalendarCell) {
            CalendarCell calendarCell = (CalendarCell)cell2;
            Calendar value = calendarCell.value();
            this.setCalendarCell(c, (org.apache.poi.ss.usermodel.Cell)cell, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cell2 instanceof HyperLinkCell) {
            HyperLinkCell hyperLinkCell = (HyperLinkCell)cell2;
            HyperLink value = hyperLinkCell.value();
            this.setHyperLinkCell((org.apache.poi.ss.usermodel.Cell)cell, value, (org.apache.poi.ss.usermodel.Row)row);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)cell2);
        }
        return cell;
    }

    private void convertCellDataFormat(CellDataFormat cdf, XSSFWorkbook workbook, XSSFCellStyle cellStyle) {
        cdf.formatString().foreach((Function1 & Serializable)formatString -> {
            Model2XlsxConversions$.$anonfun$convertCellDataFormat$1(workbook, cellStyle, formatString);
            return BoxedUnit.UNIT;
        });
    }

    public XSSFCellStyle convertCellStyle(spoiwo.model.CellStyle cs, XSSFWorkbook workbook) {
        return this.getCachedOrUpdate(this.cellStyleCache(), cs, workbook, (Function0 & Serializable)() -> {
            void var2_2;
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            cs.borders().foreach((Function1 & Serializable)b -> {
                Model2XlsxConversions$.MODULE$.convertCellBorders(b, cellStyle);
                return BoxedUnit.UNIT;
            });
            cs.dataFormat().foreach((Function1 & Serializable)df -> {
                Model2XlsxConversions$.MODULE$.convertCellDataFormat(df, workbook, cellStyle);
                return BoxedUnit.UNIT;
            });
            cs.font().foreach((Function1 & Serializable)f -> {
                cellStyle.setFont((org.apache.poi.ss.usermodel.Font)Model2XlsxConversions$.MODULE$.convertFont(f, workbook));
                return BoxedUnit.UNIT;
            });
            cs.fillPattern().foreach((Function1 & Serializable)fp -> {
                cellStyle.setFillPattern(Model2XlsxEnumConversions$.MODULE$.convertCellFill(fp));
                return BoxedUnit.UNIT;
            });
            cs.fillBackgroundColor().foreach((Function1 & Serializable)c -> {
                cellStyle.setFillBackgroundColor(Model2XlsxConversions$.MODULE$.convertColor(c));
                return BoxedUnit.UNIT;
            });
            cs.fillForegroundColor().foreach((Function1 & Serializable)c -> {
                cellStyle.setFillForegroundColor(Model2XlsxConversions$.MODULE$.convertColor(c));
                return BoxedUnit.UNIT;
            });
            cs.readingOrder().foreach((Function1 & Serializable)ro -> {
                cellStyle.setReadingOrder(Model2XlsxEnumConversions$.MODULE$.convertReadingOrder(ro));
                return BoxedUnit.UNIT;
            });
            cs.horizontalAlignment().foreach((Function1 & Serializable)ha -> {
                cellStyle.setAlignment(Model2XlsxEnumConversions$.MODULE$.convertHorizontalAlignment(ha));
                return BoxedUnit.UNIT;
            });
            cs.verticalAlignment().foreach((Function1 & Serializable)va -> {
                cellStyle.setVerticalAlignment(Model2XlsxEnumConversions$.MODULE$.convertVerticalAlignment(va));
                return BoxedUnit.UNIT;
            });
            cs.hidden().foreach((Function1 & Serializable)x$1 -> {
                cellStyle.setHidden(BoxesRunTime.unboxToBoolean((Object)x$1));
                return BoxedUnit.UNIT;
            });
            cs.indention().foreach((Function1 & Serializable)x$1 -> {
                cellStyle.setIndention(BoxesRunTime.unboxToShort((Object)x$1));
                return BoxedUnit.UNIT;
            });
            cs.locked().foreach((Function1 & Serializable)x$1 -> {
                cellStyle.setLocked(BoxesRunTime.unboxToBoolean((Object)x$1));
                return BoxedUnit.UNIT;
            });
            cs.rotation().foreach((Function1 & Serializable)x$1 -> {
                cellStyle.setRotation(BoxesRunTime.unboxToShort((Object)x$1));
                return BoxedUnit.UNIT;
            });
            cs.wrapText().foreach((Function1 & Serializable)x$1 -> {
                cellStyle.setWrapText(BoxesRunTime.unboxToBoolean((Object)x$1));
                return BoxedUnit.UNIT;
            });
            return var2_2;
        });
    }

    private void convertFooter(spoiwo.model.Footer f, XSSFSheet sheet) {
        Footer footer = sheet.getFooter();
        f.left().foreach((Function1 & Serializable)x$1 -> {
            footer.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer2 = sheet.getFooter();
        f.center().foreach((Function1 & Serializable)x$1 -> {
            footer2.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer3 = sheet.getFooter();
        f.right().foreach((Function1 & Serializable)x$1 -> {
            footer3.setRight(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer4 = sheet.getFirstFooter();
        f.firstLeft().foreach((Function1 & Serializable)x$1 -> {
            footer4.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer5 = sheet.getFirstFooter();
        f.firstCenter().foreach((Function1 & Serializable)x$1 -> {
            footer5.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer6 = sheet.getFirstFooter();
        f.firstRight().foreach((Function1 & Serializable)x$1 -> {
            footer6.setRight(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer7 = sheet.getOddFooter();
        f.oddLeft().foreach((Function1 & Serializable)x$1 -> {
            footer7.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer8 = sheet.getOddFooter();
        f.oddCenter().foreach((Function1 & Serializable)x$1 -> {
            footer8.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer9 = sheet.getOddFooter();
        f.oddRight().foreach((Function1 & Serializable)x$1 -> {
            footer9.setRight(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer10 = sheet.getEvenFooter();
        f.evenLeft().foreach((Function1 & Serializable)x$1 -> {
            footer10.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer11 = sheet.getEvenFooter();
        f.evenCenter().foreach((Function1 & Serializable)x$1 -> {
            footer11.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Footer footer12 = sheet.getEvenFooter();
        f.evenRight().foreach((Function1 & Serializable)x$1 -> {
            footer12.setRight(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public XSSFFont convertFont(Font f, XSSFWorkbook workbook) {
        return this.getCachedOrUpdate(this.fontCache(), f, workbook, (Function0 & Serializable)() -> {
            XSSFFont font = workbook.createFont();
            return MODULE$.convertFont(f, font);
        });
    }

    private void convertHeader(spoiwo.model.Header h, XSSFSheet sheet) {
        Header header = sheet.getHeader();
        h.left().foreach((Function1 & Serializable)x$1 -> {
            header.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Header header2 = sheet.getHeader();
        h.center().foreach((Function1 & Serializable)x$1 -> {
            header2.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Header header3 = sheet.getHeader();
        h.right().foreach((Function1 & Serializable)x$1 -> {
            header3.setRight(x$1);
            return BoxedUnit.UNIT;
        });
        Header header4 = sheet.getFirstHeader();
        h.firstLeft().foreach((Function1 & Serializable)x$1 -> {
            header4.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Header header5 = sheet.getFirstHeader();
        h.firstCenter().foreach((Function1 & Serializable)x$1 -> {
            header5.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Header header6 = sheet.getFirstHeader();
        h.firstRight().foreach((Function1 & Serializable)x$1 -> {
            header6.setRight(x$1);
            return BoxedUnit.UNIT;
        });
        Header header7 = sheet.getOddHeader();
        h.oddLeft().foreach((Function1 & Serializable)x$1 -> {
            header7.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Header header8 = sheet.getOddHeader();
        h.oddCenter().foreach((Function1 & Serializable)x$1 -> {
            header8.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Header header9 = sheet.getOddHeader();
        h.oddRight().foreach((Function1 & Serializable)x$1 -> {
            header9.setRight(x$1);
            return BoxedUnit.UNIT;
        });
        Header header10 = sheet.getEvenHeader();
        h.evenLeft().foreach((Function1 & Serializable)x$1 -> {
            header10.setLeft(x$1);
            return BoxedUnit.UNIT;
        });
        Header header11 = sheet.getEvenHeader();
        h.evenCenter().foreach((Function1 & Serializable)x$1 -> {
            header11.setCenter(x$1);
            return BoxedUnit.UNIT;
        });
        Header header12 = sheet.getEvenHeader();
        h.evenRight().foreach((Function1 & Serializable)x$1 -> {
            header12.setRight(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public XSSFRow convertRow(scala.collection.immutable.Map<Object, Column> modelColumns, Row modelRow, spoiwo.model.Sheet modelSheet, XSSFSheet sheet) {
        this.validateCells(modelRow);
        int indexNumber = BoxesRunTime.unboxToInt((Object)modelRow.index().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> sheet.rowIterator().hasNext() ? sheet.getLastRowNum() + 1 : 0));
        XSSFRow row = (XSSFRow)Option$.MODULE$.apply((Object)sheet.getRow(indexNumber)).getOrElse((Function0 & Serializable)() -> sheet.createRow(indexNumber));
        modelRow.height().foreach((Function1 & Serializable)h -> {
            row.setHeightInPoints((float)h.toPoints());
            return BoxedUnit.UNIT;
        });
        modelRow.style().foreach((Function1 & Serializable)s -> {
            row.setRowStyle((CellStyle)Model2XlsxConversions$.MODULE$.convertCellStyle(s, row.getSheet().getWorkbook()));
            return BoxedUnit.UNIT;
        });
        modelRow.hidden().foreach((Function1 & Serializable)x$1 -> {
            row.setZeroHeight(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        modelRow.cells().foreach((Function1 & Serializable)cell -> MODULE$.convertCell(modelSheet, modelColumns, modelRow, (Cell)cell, row));
        return row;
    }

    public XSSFSheet convertSheet(spoiwo.model.Sheet s, XSSFWorkbook workbook) {
        this.XlsxSheet(s).validate();
        return this.writeToExistingSheet(s, workbook.createSheet(this.XlsxSheet(s).nameIn(workbook)));
    }

    public XSSFSheet writeToExistingSheet(spoiwo.model.Sheet s, XSSFSheet sheet) {
        List<Column> columns = this.updateColumnsWithIndexes(s);
        scala.collection.immutable.Map columnsMap = columns.map((Function1 & Serializable)c -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c.index().get()), c)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        s.rows().foreach((Function1 & Serializable)row -> MODULE$.convertRow((scala.collection.immutable.Map<Object, Column>)columnsMap, (Row)row, s, sheet));
        columns.foreach((Function1 & Serializable)c -> {
            Model2XlsxConversions$.MODULE$.convertColumn(c, (Sheet)sheet);
            return BoxedUnit.UNIT;
        });
        s.mergedRegions().foreach((Function1 & Serializable)mergedRegion -> BoxesRunTime.boxToInteger((int)sheet.addMergedRegion(Model2XlsxConversions$.MODULE$.convertCellRange(mergedRegion))));
        s.printSetup().foreach((Function1 & Serializable)ps -> {
            Model2XlsxConversions$.MODULE$.convertPrintSetup(ps, (Sheet)sheet);
            return BoxedUnit.UNIT;
        });
        s.header().foreach((Function1 & Serializable)h -> {
            Model2XlsxConversions$.MODULE$.convertHeader(h, sheet);
            return BoxedUnit.UNIT;
        });
        s.footer().foreach((Function1 & Serializable)f -> {
            Model2XlsxConversions$.MODULE$.convertFooter(f, sheet);
            return BoxedUnit.UNIT;
        });
        s.properties().foreach((Function1 & Serializable)sp2 -> {
            Model2XlsxConversions$.MODULE$.convertSheetProperties(sp2, (Sheet)sheet);
            return BoxedUnit.UNIT;
        });
        s.locking().foreach((Function1 & Serializable)sl -> {
            Model2XlsxConversions$.MODULE$.convertSheetLocking(sl, sheet);
            return BoxedUnit.UNIT;
        });
        s.margins().foreach((Function1 & Serializable)m -> {
            Model2XlsxConversions$.MODULE$.convertMargins(m, (Sheet)sheet);
            return BoxedUnit.UNIT;
        });
        s.paneAction().foreach((Function1 & Serializable)pa -> {
            Model2XlsxConversions$.MODULE$.convertPaneAction(pa, (Sheet)sheet);
            return BoxedUnit.UNIT;
        });
        s.repeatingRows().foreach((Function1 & Serializable)rr -> {
            sheet.setRepeatingRows(Model2XlsxConversions$.MODULE$.convertRowRange(rr));
            return BoxedUnit.UNIT;
        });
        s.repeatingColumns().foreach((Function1 & Serializable)rc -> {
            sheet.setRepeatingColumns(Model2XlsxConversions$.MODULE$.convertColumnRange(rc));
            return BoxedUnit.UNIT;
        });
        s.password().foreach((Function1 & Serializable)ps -> {
            sheet.protectSheet(ps);
            return BoxedUnit.UNIT;
        });
        List<Table> tables = this.updateTablesWithIds(s);
        tables.foreach((Function1 & Serializable)tbl -> MODULE$.convertTable((Table)tbl, sheet));
        s.images().foreach((Function1 & Serializable)img -> MODULE$.addImage((Image)img, sheet));
        return sheet;
    }

    @Override
    public void setTabColor(Sheet sheet, XSSFColor color) {
        ((XSSFSheet)sheet).setTabColor(color);
    }

    @Override
    public void additionalPrintSetup(PrintSetup printSetup, org.apache.poi.ss.usermodel.PrintSetup sheetPs) {
        block0: {
            PrintSetup printSetup2 = printSetup;
            PrintSetup printSetup3 = PrintSetup$.MODULE$.Default();
            if (!(printSetup2 == null ? printSetup3 != null : !((Object)printSetup2).equals(printSetup3))) break block0;
            XSSFPrintSetup ps = (XSSFPrintSetup)sheetPs;
            printSetup.pageOrder().foreach((Function1 & Serializable)po -> {
                ps.setPageOrder(Model2XlsxEnumConversions$.MODULE$.convertPageOrder(po));
                return BoxedUnit.UNIT;
            });
            printSetup.paperSize().foreach((Function1 & Serializable)px -> {
                ps.setPaperSize(Model2XlsxEnumConversions$.MODULE$.convertPaperSize(px));
                return BoxedUnit.UNIT;
            });
        }
    }

    public void validateTables(spoiwo.model.Sheet modelSheet) {
        List ids = modelSheet.tables().flatMap((Function1 & Serializable)x$2 -> x$2.id());
        if (ids.size() != ids.toSet().size()) {
            throw new IllegalArgumentException("Specified table ids need to be unique.");
        }
    }

    public List<Table> updateTablesWithIds(spoiwo.model.Sheet modelSheet) {
        return ((List)modelSheet.tables().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Table table = (Table)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Table table2 = table.id().isDefined() ? table : table.withId(index + 1);
            return table2;
        });
    }

    public XSSFTable convertTable(Table modelTable, XSSFSheet sheet) {
        this.validateTableColumns(modelTable);
        long tableId = BoxesRunTime.unboxToLong((Object)modelTable.id().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Undefined table id! Something went terribly wrong as it should have been derived if not specified explicitly!");
        }));
        String displayName = (String)modelTable.displayName().getOrElse((Function0 & Serializable)() -> new StringBuilder(5).append("Table").append(tableId).toString());
        String name = (String)modelTable.name().getOrElse((Function0 & Serializable)() -> new StringBuilder(9).append("ct_table_").append(tableId).toString());
        XSSFTable table = sheet.createTable(null);
        table.setDisplayName(displayName);
        table.setName(name);
        CTTable ctTable = table.getCTTable();
        ctTable.setId(tableId);
        this.setTableReference(modelTable, ctTable);
        this.convertTableColumns(modelTable, ctTable);
        modelTable.style().foreach((Function1 & Serializable)x$3 -> MODULE$.convertTableStyle((TableStyle)x$3, ctTable));
        modelTable.enableAutoFilter().foreach((Function1 & Serializable)af -> Model2XlsxConversions$.$anonfun$convertTable$5(ctTable, BoxesRunTime.unboxToBoolean((Object)af)));
        return table;
    }

    public void validateTableColumns(Table modelTable) {
        if (modelTable.columns().nonEmpty() && Model2XlsxConversions$.insufficientColumnsDefined$1(modelTable)) {
            throw new IllegalArgumentException("When explicitly specifying table columns you are required to provide as many columns as in the cell range.");
        }
    }

    public CTTableColumns convertTableColumns(Table modelTable, CTTable ctTable) {
        IndexedSeq modelColumns = modelTable.columns().nonEmpty() ? modelTable.columns() : Model2XlsxConversions$.generateColumns$1(modelTable);
        CTTableColumns columns = ctTable.addNewTableColumns();
        columns.setCount((long)modelColumns.size());
        modelColumns.foreach((Function1 & Serializable)mc -> {
            Model2XlsxConversions$.$anonfun$convertTableColumns$2(columns, mc);
            return BoxedUnit.UNIT;
        });
        return columns;
    }

    public XSSFSheet convertImages(List<Image> images, XSSFSheet sheet2) {
        return (XSSFSheet)images.foldLeft((Object)sheet2, (Function2 & Serializable)(sheet, image) -> MODULE$.addImage((Image)image, (XSSFSheet)sheet));
    }

    public XSSFSheet addImage(Image image, XSSFSheet sheet) {
        int n;
        XSSFWorkbook wb = sheet.getWorkbook();
        if (image.filePath().toLowerCase().endsWith(".jpg")) {
            n = 5;
        } else if (image.filePath().toLowerCase().endsWith(".png")) {
            n = 6;
        } else {
            throw new IllegalArgumentException("File format is not supported");
        }
        int imageFormat = n;
        FileInputStream is = new FileInputStream(image.filePath());
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        int pictureIdx = wb.addPicture(bytes, imageFormat);
        XSSFCreationHelper helper = wb.getCreationHelper();
        XSSFDrawing drawing = sheet.createDrawingPatriarch();
        XSSFClientAnchor anchor = helper.createClientAnchor();
        anchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
        Tuple2<Object, Object> tuple2 = image.region().columnRange();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int fromColumn = tuple2._1$mcI$sp();
        int toColumn = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(fromColumn, toColumn);
        Tuple2.mcII.sp sp3 = sp2;
        int fromColumn2 = sp3._1$mcI$sp();
        int toColumn2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = image.region().rowRange();
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int fromRow = tuple22._1$mcI$sp();
        int toRow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(fromRow, toRow);
        Tuple2.mcII.sp sp5 = sp4;
        int fromRow2 = sp5._1$mcI$sp();
        int toRow2 = sp5._2$mcI$sp();
        anchor.setCol1(fromColumn2);
        anchor.setCol2(toColumn2);
        anchor.setRow1(fromRow2);
        anchor.setRow2(toRow2);
        XSSFPicture pict = drawing.createPicture(anchor, pictureIdx);
        pict.resize();
        return sheet;
    }

    /*
     * WARNING - void declaration
     */
    public CTTableStyleInfo convertTableStyle(TableStyle modelTableStyle, CTTable ctTable) {
        void var3_3;
        CTTableStyleInfo style = ctTable.addNewTableStyleInfo();
        style.setName(modelTableStyle.name().value());
        modelTableStyle.showColumnStripes().foreach((Function1 & Serializable)x$1 -> {
            style.setShowColumnStripes(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        modelTableStyle.showRowStripes().foreach((Function1 & Serializable)x$1 -> {
            style.setShowRowStripes(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public void setTableReference(Table modelTable, CTTable ctTable) {
        CellRangeAddress cellRangeAddress = this.convertCellRange(modelTable.cellRange());
        ctTable.setRef(cellRangeAddress.formatAsString());
    }

    public XSSFWorkbook convertWorkbook(Workbook wb) {
        return this.writeToExistingWorkbook(wb, new XSSFWorkbook());
    }

    public XSSFWorkbook writeToExistingWorkbook(Workbook wb, XSSFWorkbook workbook) {
        wb.sheets().foreach((Function1 & Serializable)s -> {
            MODULE$.XlsxSheet((spoiwo.model.Sheet)s).validate();
            String sheetName = MODULE$.XlsxSheet((spoiwo.model.Sheet)s).nameIn(workbook);
            return MODULE$.writeToExistingSheet((spoiwo.model.Sheet)s, (XSSFSheet)Option$.MODULE$.apply((Object)workbook.getSheet(sheetName)).getOrElse((Function0 & Serializable)() -> workbook.createSheet(sheetName)));
        });
        wb.activeSheet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> workbook.setActiveSheet(x$1));
        wb.firstVisibleTab().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> workbook.setFirstVisibleTab(x$1));
        wb.forceFormulaRecalculation().foreach((Function1 & Serializable)x$1 -> {
            workbook.setForceFormulaRecalculation(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        wb.hidden().foreach((Function1 & Serializable)x$1 -> {
            workbook.setHidden(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        wb.missingCellPolicy().foreach((Function1 & Serializable)mcp -> {
            workbook.setMissingCellPolicy(Model2XlsxEnumConversions$.MODULE$.convertMissingCellPolicy(mcp));
            return BoxedUnit.UNIT;
        });
        wb.selectedTab().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> workbook.setSelectedTab(x$1));
        this.evictFromCache(workbook);
        return workbook;
    }

    private void evictFromCache(XSSFWorkbook wb) {
        this.cellStyleCache().remove((Object)wb);
        this.dataFormatCache().remove((Object)wb);
        this.fontCache().remove((Object)wb);
    }

    private <K, V> V getCachedOrUpdate(Map<XSSFWorkbook, Map<K, V>> cache, K value, XSSFWorkbook workbook, Function0<V> newValue) {
        Map workbookCache = (Map)cache.getOrElseUpdate((Object)workbook, (Function0 & Serializable)() -> (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        return (V)workbookCache.getOrElseUpdate(value, newValue);
    }

    public Model2XlsxConversions.XlsxBorderStyle XlsxBorderStyle(CellBorderStyle bs) {
        return new Model2XlsxConversions.XlsxBorderStyle(bs);
    }

    public Model2XlsxConversions.XlsxColor XlsxColor(Color c) {
        return new Model2XlsxConversions.XlsxColor(c);
    }

    public Model2XlsxConversions.XlsxCellFill XlsxCellFill(CellFill cf) {
        return new Model2XlsxConversions.XlsxCellFill(cf);
    }

    public Model2XlsxConversions.XlsxCellStyle XlsxCellStyle(spoiwo.model.CellStyle cs) {
        return new Model2XlsxConversions.XlsxCellStyle(cs);
    }

    public Model2XlsxConversions.XlsxFont XlsxFont(Font f) {
        return new Model2XlsxConversions.XlsxFont(f);
    }

    public Model2XlsxConversions.XlsxHorizontalAlignment XlsxHorizontalAlignment(CellHorizontalAlignment ha) {
        return new Model2XlsxConversions.XlsxHorizontalAlignment(ha);
    }

    public Model2XlsxConversions.XlsxReadingOrder XlsxReadingOrder(CellReadingOrder ro) {
        return new Model2XlsxConversions.XlsxReadingOrder(ro);
    }

    public Model2XlsxConversions.XlsxSheet XlsxSheet(spoiwo.model.Sheet s) {
        return new Model2XlsxConversions.XlsxSheet(s);
    }

    public Model2XlsxConversions.XlsxVerticalAlignment XlsxVerticalAlignment(CellVerticalAlignment va) {
        return new Model2XlsxConversions.XlsxVerticalAlignment(va);
    }

    public Model2XlsxConversions.XlsxWorkbook XlsxWorkbook(Workbook workbook) {
        return new Model2XlsxConversions.XlsxWorkbook(workbook);
    }

    public static final /* synthetic */ void $anonfun$convertCellDataFormat$1(XSSFWorkbook workbook$1, XSSFCellStyle cellStyle$1, String formatString) {
        XSSFDataFormat format = (XSSFDataFormat)MODULE$.dataFormatCache().getOrElseUpdate((Object)workbook$1, (Function0 & Serializable)() -> workbook$1.createDataFormat());
        short formatIndex = format.getFormat(formatString);
        cellStyle$1.setDataFormat(formatIndex);
    }

    public static final /* synthetic */ Object $anonfun$convertTable$5(CTTable ctTable$1, boolean af) {
        return af ? ctTable$1.addNewAutoFilter() : BoxedUnit.UNIT;
    }

    private static final boolean insufficientColumnsDefined$1(Table modelTable$1) {
        Tuple2<Object, Object> tuple2 = modelTable$1.cellRange().columnRange();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int sCol = tuple2._1$mcI$sp();
        int eCol = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(sCol, eCol);
        Tuple2.mcII.sp sp3 = sp2;
        int sCol2 = sp3._1$mcI$sp();
        int eCol2 = sp3._2$mcI$sp();
        int neededColumns = eCol2 - sCol2 + 1;
        int definedColumns = modelTable$1.columns().size();
        return neededColumns != definedColumns;
    }

    public static final /* synthetic */ TableColumn $anonfun$convertTableColumns$1(int index) {
        int columnId = index + 1;
        return new TableColumn(new StringBuilder(11).append("TableColumn").append(columnId).toString(), columnId);
    }

    private static final IndexedSeq generateColumns$1(Table modelTable$2) {
        Tuple2<Object, Object> tuple2 = modelTable$2.cellRange().columnRange();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int sCol = tuple2._1$mcI$sp();
        int eCol = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(sCol, eCol);
        Tuple2.mcII.sp sp3 = sp2;
        int sCol2 = sp3._1$mcI$sp();
        int eCol2 = sp3._2$mcI$sp();
        int neededColumns = eCol2 - sCol2 + 1;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), neededColumns).map((Function1 & Serializable)index -> Model2XlsxConversions$.$anonfun$convertTableColumns$1(BoxesRunTime.unboxToInt((Object)index)));
    }

    public static final /* synthetic */ void $anonfun$convertTableColumns$2(CTTableColumns columns$1, TableColumn mc) {
        CTTableColumn column = columns$1.addNewTableColumn();
        column.setName(mc.name());
        column.setId(mc.id());
    }

    private Model2XlsxConversions$() {
    }
}

