/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import java.io.Serializable;
import java.util.Comparator;

public final class CircularRange<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> comparator;
    private final T minimum;
    private final T maximum;
    private final T circleStart;
    private final T circleEnd;
    private transient int hashCode;
    private transient String toString;

    private CircularRange(T circleStart, T circleEnd, T minimum, T maximum, Comparator<T> comp) {
        if (circleStart == null || circleEnd == null) {
            throw new IllegalArgumentException("Circular boundaries must not be null: circleStart=" + circleStart + ", circleEnd=" + circleEnd);
        }
        if (minimum == null || maximum == null) {
            throw new IllegalArgumentException("Elements in a range must not be null: minimum=" + minimum + ", maximum=" + maximum);
        }
        this.comparator = comp == null ? ComparableComparator.INSTANCE : comp;
        if (!this.inNormalRange(minimum, circleStart, circleEnd) || !this.inNormalRange(maximum, circleStart, circleEnd)) {
            throw new IllegalArgumentException("Elements in a range must fit between circular start/end: circleStart=" + circleStart + ", circleEnd=" + circleEnd + ", minimum=" + minimum + ", maximum=" + maximum);
        }
        if (this.compare(circleEnd, circleStart) < 1) {
            throw new IllegalArgumentException("Circular start must be smaller than circlar end: circleStart=" + circleStart + ", circleEnd=" + circleEnd);
        }
        this.circleStart = circleStart;
        this.circleEnd = circleEnd;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public static <T extends Comparable<T>> CircularRange<T> is(T element) {
        return CircularRange.between(element, element, null);
    }

    public static <T> CircularRange<T> is(T element, Comparator<T> comparator) {
        return CircularRange.between(element, element, comparator);
    }

    public static <T extends Comparable<T>> CircularRange<T> between(T fromInclusive, T toInclusive) {
        return CircularRange.between(fromInclusive, toInclusive, null);
    }

    public static <T> CircularRange<T> between(T fromInclusive, T toInclusive, Comparator<T> comparator) {
        return CircularRange.between(fromInclusive, toInclusive, fromInclusive, toInclusive, comparator);
    }

    public static <T extends Comparable<T>> CircularRange<T> between(T circleStartInclusive, T circleEndInclusive, T rangeFromInclusive, T rangeToInclusive) {
        return CircularRange.between(circleStartInclusive, circleEndInclusive, rangeFromInclusive, rangeToInclusive, null);
    }

    public static <T> CircularRange<T> between(T circleStartInclusive, T circleEndInclusive, T rangeFromInclusive, T rangeToInclusive, Comparator<T> comparator) {
        return new CircularRange<T>(circleStartInclusive, circleEndInclusive, rangeFromInclusive, rangeToInclusive, comparator);
    }

    public CircularRange<T> withCircularBoundaries(T circleStartInclusive, T circleEndInclusive) {
        return new CircularRange<T>(circleStartInclusive, circleEndInclusive, this.getMinimum(), this.getMaximum(), this.getComparator());
    }

    public CircularRange<T> withRange(T rangeFromInclusive, T rangeToInclusive) {
        return new CircularRange<T>(this.getCircleStart(), this.getCircleEnd(), rangeFromInclusive, rangeToInclusive, this.getComparator());
    }

    public T getMinimum() {
        return this.minimum;
    }

    public T getMaximum() {
        return this.maximum;
    }

    public T getCircleStart() {
        return this.circleStart;
    }

    public T getCircleEnd() {
        return this.circleEnd;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public boolean isNaturalOrdering() {
        return this.comparator == ComparableComparator.INSTANCE;
    }

    public boolean isRolling() {
        return this.compare(this.minimum, this.maximum) > -1;
    }

    public boolean contains(T element) {
        if (element == null) {
            return false;
        }
        if (!this.isRolling()) {
            return this.inNormalRange(element, this.minimum, this.maximum);
        }
        return this.inNormalRange(element, this.minimum, this.circleEnd) || this.inNormalRange(element, this.circleStart, this.maximum);
    }

    public boolean isStartedBy(T element) {
        if (element == null) {
            return false;
        }
        return this.compare(element, this.minimum) == 0;
    }

    public boolean isEndedBy(T element) {
        if (element == null) {
            return false;
        }
        return this.compare(element, this.maximum) == 0;
    }

    public boolean containsRange(CircularRange<T> otherRange) {
        if (otherRange == null) {
            return false;
        }
        if (!this.isRolling() && !otherRange.isRolling()) {
            return this.contains(otherRange.minimum) && this.contains(otherRange.maximum);
        }
        if (this.isRolling() && otherRange.isRolling()) {
            return this.inNormalRange(otherRange.minimum, this.minimum, this.circleEnd) && this.inNormalRange(otherRange.maximum, this.circleStart, this.maximum);
        }
        if (this.isRolling() && !otherRange.isRolling()) {
            return this.inNormalRange(otherRange.minimum, this.minimum, this.circleEnd) && this.inNormalRange(otherRange.maximum, this.minimum, this.circleEnd) || this.inNormalRange(otherRange.minimum, this.circleStart, this.maximum) && this.inNormalRange(otherRange.maximum, this.circleStart, this.maximum);
        }
        return false;
    }

    public boolean isOverlappedBy(CircularRange<T> otherRange) {
        if (otherRange == null) {
            return false;
        }
        return otherRange.contains(this.minimum) || otherRange.contains(this.maximum) || this.contains(otherRange.minimum);
    }

    private int compare(T o1, T o2) {
        return this.comparator.compare(o1, o2);
    }

    private boolean inNormalRange(T element, T min, T max) {
        return this.compare(element, min) > -1 && this.compare(element, max) < 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CircularRange range = (CircularRange)obj;
        return this.minimum.equals(range.minimum) && this.maximum.equals(range.maximum) && this.circleStart.equals(range.circleStart) && this.circleEnd.equals(range.circleEnd);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (this.hashCode == 0) {
            result = 17;
            result = 37 * result + this.getClass().hashCode();
            result = 37 * result + this.minimum.hashCode();
            result = 37 * result + this.maximum.hashCode();
            result = 37 * result + this.circleStart.hashCode();
            this.hashCode = result = 37 * result + this.circleEnd.hashCode();
        }
        return result;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "[" + this.minimum + ".." + this.maximum + "](" + this.circleStart + ".." + this.circleEnd + ")";
        }
        return this.toString;
    }

    public String toString(String format) {
        return String.format(format, this.minimum, this.maximum, this.circleStart, this.circleEnd, this.comparator);
    }

    private static enum ComparableComparator implements Comparator
    {
        INSTANCE;


        public int compare(Object obj1, Object obj2) {
            return ((Comparable)obj1).compareTo(obj2);
        }
    }
}

