/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class ClassFinder {
    private static final Logger LOG = Logger.getLogger(ClassFinder.class);

    private ClassFinder() {
    }

    public static List<String> findSubTypes(Class<?> superClass) {
        Enumeration<URL> roots;
        ArrayList<String> classes = new ArrayList<String>();
        if (superClass == null) {
            return classes;
        }
        try {
            roots = ClassFinder.class.getClassLoader().getResources("");
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot obtain class roots for class: " + superClass), (Throwable)e);
            return classes;
        }
        while (roots.hasMoreElements()) {
            URL url = roots.nextElement();
            File root = new File(url.getPath());
            classes.addAll(ClassFinder.findSubTypes(root, superClass));
        }
        return classes;
    }

    public static List<String> findSubTypes(List<File> files, Class<?> superClass) {
        ArrayList<String> classes = new ArrayList<String>();
        if (superClass == null || files == null) {
            return classes;
        }
        for (File file : files) {
            classes.addAll(ClassFinder.findSubTypes(file, superClass));
        }
        return classes;
    }

    public static List<String> findSubTypes(File file, Class<?> superClass) {
        if (superClass == null) {
            return new ArrayList<String>();
        }
        if (file == null || !file.exists()) {
            LOG.warn((Object)("Trying to find implementing classes from a null or non-existant file: " + file));
            return new ArrayList<String>();
        }
        if (file.isDirectory()) {
            return ClassFinder.findSubTypesFromDirectory(file, superClass);
        }
        if (file.getName().endsWith(".jar")) {
            return ClassFinder.findSubTypesFromJar(file, superClass);
        }
        LOG.warn((Object)"File not a JAR and not a directory.");
        return new ArrayList<String>();
    }

    private static List<String> findSubTypesFromDirectory(File dir, Class<?> superClass) {
        ArrayList<String> classes = new ArrayList<String>();
        String dirPath = dir.getAbsolutePath();
        Collection classFiles = FileUtils.listFiles((File)dir, (String[])new String[]{"class"}, (boolean)true);
        ClassLoader loader = ClassFinder.getClassLoader(dir);
        if (loader == null) {
            return classes;
        }
        for (File classFile : classFiles) {
            String filePath = classFile.getAbsolutePath();
            String className = StringUtils.removeStart((String)filePath, (String)dirPath);
            if ((className = ClassFinder.resolveName(loader, className, superClass)) == null) continue;
            classes.add(className);
        }
        return classes;
    }

    private static List<String> findSubTypesFromJar(File jarFile, Class<?> superClass) {
        ArrayList<String> classes = new ArrayList<String>();
        ClassLoader loader = ClassFinder.getClassLoader(jarFile);
        if (loader == null) {
            return classes;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile);
            jar.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Invalid JAR: " + jarFile), (Throwable)e);
            return classes;
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String className = entry.getName();
            if ((className = ClassFinder.resolveName(loader, className, superClass)) == null) continue;
            classes.add(className);
        }
        try {
            jar.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Could not close JAR.", (Throwable)e);
        }
        return classes;
    }

    private static ClassLoader getClassLoader(File url) {
        try {
            URL dirURL = url.toURI().toURL();
            return new URLClassLoader(new URL[]{dirURL}, ClassFinder.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Invalid classpath: " + url), (Throwable)e);
            return null;
        }
    }

    private static String resolveName(ClassLoader loader, String rawName, Class<?> superClass) {
        String className = rawName;
        if (!rawName.endsWith(".class") || className.contains("$")) {
            return null;
        }
        className = className.replaceAll("[\\\\/]", ".");
        className = StringUtils.removeStart((String)className, (String)".");
        className = StringUtils.removeEnd((String)className, (String)".class");
        try {
            Class<?> clazz = loader.loadClass(className);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers()) && superClass.isAssignableFrom(clazz)) {
                return clazz.getName();
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Invalid class: " + className), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOG.debug((Object)("Invalid class: " + className), (Throwable)e);
        }
        return null;
    }
}

