/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class EqualsUtil {
    private EqualsUtil() {
    }

    public static boolean equalsAny(Object source, Object ... targets) {
        if (targets == null) {
            return source == null;
        }
        for (Object object : targets) {
            if (!Objects.equals(source, object)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(String source, String ... targets) {
        if (targets == null) {
            return source == null;
        }
        for (String target : targets) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)target)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAll(Object source, Object ... targets) {
        if (targets == null) {
            return source == null;
        }
        for (Object object : targets) {
            if (Objects.equals(source, object)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAllIgnoreCase(String source, String ... targets) {
        if (targets == null) {
            return source == null;
        }
        for (String target : targets) {
            if (StringUtils.equalsIgnoreCase((CharSequence)source, (CharSequence)target)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsNone(Object source, Object ... targets) {
        return !EqualsUtil.equalsAny(source, targets);
    }

    public static boolean equalsNoneIgnoreCase(String source, String ... targets) {
        return !EqualsUtil.equalsAnyIgnoreCase(source, targets);
    }

    public static boolean equalsMap(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        return map1.entrySet().containsAll(map2.entrySet());
    }
}

