/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public class PercentFormatter
implements Serializable {
    private static final long serialVersionUID = 3403860660255503075L;
    private final Locale locale;
    private final int decimalPrecision;

    public PercentFormatter() {
        this.decimalPrecision = 0;
        this.locale = null;
    }

    public PercentFormatter(int decimalPrecision, Locale locale) {
        this.decimalPrecision = decimalPrecision;
        this.locale = locale;
    }

    public String format(double numerator, double denominator) {
        return PercentFormatter.format(numerator, denominator, this.decimalPrecision, this.locale);
    }

    public String format(double fraction) {
        return PercentFormatter.format(fraction, this.decimalPrecision, this.locale);
    }

    public static String format(double numerator, double denominator, int decimalPrecision, Locale locale) {
        return PercentFormatter.format(BigDecimal.valueOf(numerator).divide(BigDecimal.valueOf(denominator), decimalPrecision + 2, RoundingMode.HALF_UP).doubleValue(), decimalPrecision + 2, locale);
    }

    public static String format(double fraction, int decimalPrecision, Locale locale) {
        Locale safeLocale = locale;
        if (safeLocale == null) {
            safeLocale = Locale.getDefault();
        }
        NumberFormat percentFormat = NumberFormat.getPercentInstance(safeLocale);
        percentFormat.setMaximumFractionDigits(decimalPrecision);
        return percentFormat.format(fraction);
    }
}

