/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class ResourceLoader {
    private static final Logger LOG = Logger.getLogger(ResourceLoader.class);

    private ResourceLoader() {
    }

    public static InputStream getStream(Class<?> clazz, String suffix) {
        if (clazz == null) {
            LOG.debug((Object)("Class is null for suffix: " + suffix));
            return null;
        }
        return clazz.getResourceAsStream(clazz.getSimpleName() + suffix);
    }

    public static Reader getReader(Class<?> clazz, String suffix) {
        InputStream is = ResourceLoader.getStream(clazz, suffix);
        if (is == null) {
            LOG.debug((Object)("InputStream is null for class/suffix: " + clazz + "/" + suffix));
            return null;
        }
        return new InputStreamReader(is, StandardCharsets.UTF_8);
    }

    public static String getString(Class<?> clazz, String suffix) {
        Reader r = ResourceLoader.getReader(clazz, suffix);
        if (r == null) {
            LOG.debug((Object)("Reader is null for class/suffix: " + clazz + "/" + suffix));
            return null;
        }
        try {
            return IOUtils.toString((Reader)r);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load class/suffix as string: " + clazz + "/" + suffix), (Throwable)e);
            return null;
        }
    }

    public static InputStream getXmlStream(Class<?> clazz) {
        return ResourceLoader.getStream(clazz, ".xml");
    }

    public static Reader getXmlReader(Class<?> clazz) {
        return ResourceLoader.getReader(clazz, ".xml");
    }

    public static String getXmlString(Class<?> clazz) {
        return ResourceLoader.getString(clazz, ".xml");
    }

    public static InputStream getTxtStream(Class<?> clazz) {
        return ResourceLoader.getStream(clazz, ".txt");
    }

    public static Reader getTxtReader(Class<?> clazz) {
        return ResourceLoader.getReader(clazz, ".txt");
    }

    public static String getTxtString(Class<?> clazz) {
        return ResourceLoader.getString(clazz, ".txt");
    }

    public static InputStream getHtmlStream(Class<?> clazz) {
        return ResourceLoader.getStream(clazz, ".html");
    }

    public static Reader getHtmlReader(Class<?> clazz) {
        return ResourceLoader.getReader(clazz, ".html");
    }

    public static String getHtmlString(Class<?> clazz) {
        return ResourceLoader.getString(clazz, ".html");
    }
}

