/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import com.norconex.commons.lang.SleeperException;
import java.util.concurrent.TimeUnit;

public final class Sleeper {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;

    private Sleeper() {
    }

    public static void sleepMillis(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new SleeperException("Cannot sleep.", e);
        }
    }

    public static void sleepNanos(long nanoSeconds) {
        long milis = TimeUnit.NANOSECONDS.toMillis(nanoSeconds);
        int nanoRemains = (int)(nanoSeconds - TimeUnit.MILLISECONDS.toNanos(milis));
        try {
            Thread.sleep(milis, nanoRemains);
        }
        catch (InterruptedException e) {
            throw new SleeperException("Cannot sleep.", e);
        }
    }

    public static void sleepSeconds(int seconds) {
        Sleeper.sleepMillis((long)seconds * 1000L);
    }

    public static void sleepMinutes(int minutes) {
        Sleeper.sleepMillis((long)minutes * 60000L);
    }

    public static void sleepHours(int hours) {
        Sleeper.sleepMillis((long)hours * 3600000L);
    }
}

