/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class StringUtil {
    private static final Logger LOG = LogManager.getLogger(StringUtil.class);
    public static final int TRUNCATE_HASH_LENGTH = 10;

    private StringUtil() {
    }

    public static String truncateWithHash(String text, int maxLength) {
        return StringUtil.truncateWithHash(text, maxLength, null);
    }

    public static String truncateWithHash(String text, int maxLength, String separator) {
        if (text == null) {
            return null;
        }
        if (text.length() <= maxLength) {
            return text;
        }
        int separatorLength = separator == null ? 0 : separator.length();
        int roomLength = 10 + separatorLength;
        if (maxLength < roomLength) {
            LOG.warn((Object)("\"maxLength\" is smaller than hash length (10) + separator length (" + separatorLength + "). No truncation will occur."));
        }
        int cutIndex = maxLength - roomLength;
        String truncated = StringUtils.left((String)text, (int)cutIndex);
        String remainer = StringUtils.substring((String)text, (int)cutIndex);
        if (separator != null) {
            truncated = truncated + separator;
        }
        truncated = truncated + StringUtil.getHash(remainer);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Truncated text: " + truncated));
        }
        return truncated;
    }

    public static String truncateBytesWithHash(String text, Charset charset, int maxByteLength) throws CharacterCodingException {
        if (text == null) {
            return null;
        }
        return new String(StringUtil.truncateBytesWithHash(text.getBytes(charset), charset, maxByteLength, null), charset);
    }

    public static String truncateBytesWithHash(String text, Charset charset, int maxByteLength, String separator) throws CharacterCodingException {
        if (text == null) {
            return null;
        }
        return new String(StringUtil.truncateBytesWithHash(text.getBytes(charset), charset, maxByteLength, separator), charset);
    }

    public static byte[] truncateBytesWithHash(byte[] bytes, Charset charset, int maxByteLength) throws CharacterCodingException {
        if (bytes == null) {
            return null;
        }
        return StringUtil.truncateBytesWithHash(bytes, charset, maxByteLength, null);
    }

    public static byte[] truncateBytesWithHash(byte[] bytes, Charset charset, int maxByteLength, String separator) throws CharacterCodingException {
        if (bytes == null) {
            return null;
        }
        if (bytes.length <= maxByteLength) {
            return bytes;
        }
        Charset nullSafeCharset = charset;
        if (nullSafeCharset == null) {
            nullSafeCharset = StandardCharsets.UTF_8;
        }
        int separatorLength = separator == null ? 0 : separator.getBytes(nullSafeCharset).length;
        int hashLength = StringUtils.repeat((char)'0', (int)10).getBytes(nullSafeCharset).length;
        int roomLength = hashLength + separatorLength;
        if (maxByteLength < roomLength) {
            LOG.warn((Object)("\"maxLength\" is smaller in bytes than hash length (" + hashLength + ") + separator length (" + separatorLength + "). No truncation will occur."));
        }
        int cutIndex = maxByteLength - roomLength;
        CharsetDecoder decoder = nullSafeCharset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.reset();
        String fullString = new String(bytes, nullSafeCharset);
        String truncated = decoder.decode(ByteBuffer.wrap(bytes, 0, cutIndex)).toString();
        String remainer = StringUtils.substring((String)fullString, (int)truncated.length());
        if (separator != null) {
            truncated = truncated + separator;
        }
        truncated = truncated + StringUtil.getHash(remainer);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Truncated text: " + truncated));
        }
        return truncated.getBytes(nullSafeCharset);
    }

    static String getHash(String s) {
        return StringUtils.leftPad((String)StringUtils.stripStart((String)Integer.toString(s.hashCode()), (String)"-"), (int)10, (char)'0');
    }
}

