/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang;

import com.norconex.commons.lang.Sleeper;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class TimeIdGenerator {
    private static final Logger LOG = LogManager.getLogger(TimeIdGenerator.class);
    private static final AtomicInteger DUP_SEQUENCE = new AtomicInteger();
    private static final long MILLIS_ROLLOVER_VALUE = BigDecimal.valueOf(1.0E14).longValueExact();
    private static final int MAX_DUP_SEQUENCE = 999999;
    private static final int TIME_MULTIPLIER = 1000000;
    private static long previousTime = -1L;
    private static long previousGeneratedId = -1L;
    private static int previousGeneratedDupSequence = 0;

    private TimeIdGenerator() {
    }

    public static synchronized long last() {
        return previousGeneratedId;
    }

    public static synchronized long next() {
        long time = System.currentTimeMillis() % MILLIS_ROLLOVER_VALUE;
        long id = time * 1000000L;
        boolean bl = time == previousTime;
        previousTime = time;
        previousGeneratedId = id += (long)TimeIdGenerator.getDupSequence(bl);
        return id;
    }

    private static int getDupSequence(boolean needsIncrement) {
        if (needsIncrement) {
            int dupSeq;
            previousGeneratedDupSequence = dupSeq = DUP_SEQUENCE.incrementAndGet();
            if (dupSeq == 999999) {
                while (System.currentTimeMillis() == previousTime) {
                    Sleeper.sleepNanos(1L);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Reached 1000000 ID creations in one millisecond. Had to wait for current millisecond to pass.");
                }
            }
            return dupSeq;
        }
        if (previousGeneratedDupSequence != 0) {
            DUP_SEQUENCE.set(0);
            previousGeneratedDupSequence = 0;
        }
        return 0;
    }
}

