/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.config;

import com.norconex.commons.lang.config.ConfigurationException;
import com.norconex.commons.lang.config.RelativeIncludeEventHandler;
import com.norconex.commons.lang.config.XMLConfigurationUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public final class ConfigurationLoader {
    private static final String EXTENSION_PROPERTIES = ".properties";
    private static final String EXTENSION_VARIABLES = ".variables";
    private final VelocityEngine velocityEngine;

    public ConfigurationLoader() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("eventhandler.include.class", (Object)RelativeIncludeEventHandler.class.getName());
        this.velocityEngine.setProperty("resource.loader", (Object)"file");
        this.velocityEngine.setProperty("file.resource.loader.path", (Object)"");
        this.velocityEngine.setProperty("input.encoding", (Object)"UTF-8");
        this.velocityEngine.setProperty("output.encoding", (Object)"UTF-8");
        this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.Log4JLogChute");
        this.velocityEngine.setProperty("runtime.log", (Object)"");
    }

    public ConfigurationLoader(Properties velocityProperties) {
        try {
            this.velocityEngine = new VelocityEngine(velocityProperties);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create parsing Velocity engine.", e);
        }
    }

    public XMLConfiguration loadXML(File configFile) {
        return this.loadXML(configFile, null);
    }

    public XMLConfiguration loadXML(File configFile, File variables) {
        if (!configFile.exists()) {
            return null;
        }
        try {
            String xml = this.loadString(configFile, variables);
            xml = Pattern.compile("((?!^)<\\?xml.*?\\?>|<\\!DOCTYPE.*?>)", 8).matcher(xml).replaceAll("");
            return XMLConfigurationUtil.newXMLConfiguration(new StringReader(xml));
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot load configuration file: \"" + configFile + "\". " + "Probably a misconfiguration or the configuration XML " + "is not well-formed.", e);
        }
    }

    public String loadString(File configFile, File variables) {
        if (configFile == null) {
            throw new ConfigurationException("No configuration file specified.");
        }
        if (!configFile.exists()) {
            return null;
        }
        VelocityContext context = new VelocityContext();
        this.loadVariables(context, variables);
        String file = configFile.getAbsolutePath();
        String fullpath = FilenameUtils.getFullPath((String)file);
        String baseName = FilenameUtils.getBaseName((String)file);
        File varsFile = this.getVariablesFile(fullpath, baseName);
        if (varsFile != null) {
            this.loadVariables(context, varsFile);
        }
        StringWriter sw = new StringWriter();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
            this.velocityEngine.evaluate((Context)context, (Writer)sw, configFile.getAbsolutePath(), (Reader)reader);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot load config file as a string: " + file, e);
        }
        return sw.toString();
    }

    private File getVariablesFile(String fullpath, String baseName) {
        File vars = new File(fullpath + baseName + EXTENSION_PROPERTIES);
        if (this.isVariableFile(vars, EXTENSION_PROPERTIES)) {
            return vars;
        }
        vars = new File(fullpath + baseName + EXTENSION_VARIABLES);
        if (this.isVariableFile(vars, EXTENSION_VARIABLES)) {
            return vars;
        }
        return null;
    }

    private void loadVariables(VelocityContext context, File vars) {
        block17: {
            try {
                if (this.isVariableFile(vars, EXTENSION_VARIABLES)) {
                    FileInputStream is = new FileInputStream(vars);
                    List lines = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    is.close();
                    for (String line : lines) {
                        if (!line.contains("=")) continue;
                        String key = StringUtils.substringBefore((String)line, (String)"=").trim();
                        String value = StringUtils.substringAfter((String)line, (String)"=").trim();
                        context.put(key, (Object)value);
                    }
                    break block17;
                }
                if (!this.isVariableFile(vars, EXTENSION_PROPERTIES)) break block17;
                Properties props = new Properties();
                try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(vars), StandardCharsets.UTF_8);){
                    props.load(r);
                }
                for (String key : props.stringPropertyNames()) {
                    context.put(key, (Object)props.getProperty(key));
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Cannot load variables from file: " + vars, e);
            }
        }
    }

    private boolean isVariableFile(File vars, String extension) {
        return vars != null && vars.exists() && vars.isFile() && vars.getName().endsWith(extension);
    }
}

