/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.velocity.app.event.IncludeEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.util.ContextAware;

public class RelativeIncludeEventHandler
implements IncludeEventHandler,
ContextAware {
    private static final Logger LOG = LogManager.getLogger(RelativeIncludeEventHandler.class);
    private Context context;

    public String includeEvent(String includeResourcePath, String currentResourcePath, String directiveName) {
        File vars;
        String inclFile;
        if (includeResourcePath.startsWith("/") || includeResourcePath.startsWith("\\") || includeResourcePath.startsWith("file://") || includeResourcePath.matches("^[A-Za-z]:\\.*")) {
            inclFile = includeResourcePath;
        } else {
            String baseDir = FilenameUtils.getFullPath((String)currentResourcePath);
            inclFile = FilenameUtils.normalize((String)(baseDir + includeResourcePath));
        }
        if (this.context != null && (vars = new File(FilenameUtils.getFullPath((String)inclFile) + FilenameUtils.getBaseName((String)inclFile) + ".properties")).exists() && vars.isFile()) {
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(vars);){
                props.load(is);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    this.context.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot load properties for template (skipped): " + vars), (Throwable)e);
            }
        }
        return inclFile;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

