/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.config;

import com.norconex.commons.lang.config.ConfigurationException;
import com.norconex.commons.lang.config.IXMLConfigurable;
import com.norconex.commons.lang.time.DurationParser;
import java.awt.Dimension;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.xerces.xni.NamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class XMLConfigurationUtil {
    private static final Logger LOG = LogManager.getLogger(XMLConfigurationUtil.class);
    public static final String W3C_XML_SCHEMA_NS_URI_1_1 = "http://www.w3.org/XML/XMLSchema/v1.1";

    private XMLConfigurationUtil() {
    }

    public static void disableDelimiterParsing(XMLConfiguration xml) {
        xml.setListDelimiter('\u0000');
        xml.setDelimiterParsingDisabled(true);
        xml.setAttributeSplittingDisabled(true);
    }

    public static XMLConfiguration newXMLConfiguration(HierarchicalConfiguration c) {
        XMLConfiguration xml = new XMLConfiguration(c);
        XMLConfigurationUtil.disableDelimiterParsing(xml);
        return xml;
    }

    public static XMLConfiguration newXMLConfiguration(Reader in) {
        XMLConfiguration xml = new XMLConfiguration();
        XMLConfigurationUtil.disableDelimiterParsing(xml);
        try {
            xml.load(in);
        }
        catch (org.apache.commons.configuration.ConfigurationException e) {
            throw new ConfigurationException("Cannot load XMLConfiguration", e);
        }
        return xml;
    }

    public static <T> T newInstance(Reader reader) {
        return XMLConfigurationUtil.newInstance((HierarchicalConfiguration)XMLConfigurationUtil.newXMLConfiguration(reader));
    }

    public static <T> T newInstance(HierarchicalConfiguration node) {
        return XMLConfigurationUtil.newInstance(node, (String)null);
    }

    public static <T> T newInstance(HierarchicalConfiguration node, T defaultObject) {
        Object obj;
        if (node == null) {
            return defaultObject;
        }
        String clazz = node.getString("[@class]", null);
        if (clazz != null) {
            try {
                obj = Class.forName(clazz).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("This class could not be instantiated: \"" + clazz + "\".", e);
            }
        } else {
            LOG.debug((Object)("A configuration entry was found without class reference where one could have been provided; using default value:" + defaultObject));
            obj = defaultObject;
        }
        if (obj == null) {
            return defaultObject;
        }
        if (obj instanceof IXMLConfigurable) {
            XMLConfigurationUtil.loadFromXML((IXMLConfigurable)obj, node);
        }
        return (T)obj;
    }

    public static <T> T newInstance(HierarchicalConfiguration node, String key) {
        return XMLConfigurationUtil.newInstance(node, key, null, true);
    }

    public static <T> T newInstance(HierarchicalConfiguration node, String key, T defaultObject) {
        return XMLConfigurationUtil.newInstance(node, key, defaultObject, false);
    }

    private static <T> T newInstance(HierarchicalConfiguration node, String key, T defaultObject, boolean canThrowException) {
        if (node == null) {
            return defaultObject;
        }
        try {
            if (key == null && defaultObject == null) {
                return XMLConfigurationUtil.newInstance(node, null);
            }
            HierarchicalConfiguration subconfig = XMLConfigurationUtil.safeConfigurationAt(node, key);
            return XMLConfigurationUtil.newInstance(subconfig, defaultObject);
        }
        catch (Exception e) {
            XMLConfigurationUtil.handleException(node.getRootNode(), key, e, canThrowException);
            return defaultObject;
        }
    }

    private static void handleException(ConfigurationNode rootNode, String key, Exception e, boolean canThrowException) {
        if (canThrowException) {
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)e;
            }
            throw new ConfigurationException("Could not instantiate object from configuration for \"" + rootNode.getName() + " -> " + key + "\".", e);
        }
        if (e instanceof ConfigurationException && e.getCause() != null) {
            if (e.getCause() instanceof ClassNotFoundException) {
                LOG.error((Object)("You declared a class that does not exists for \"" + rootNode.getName() + " -> " + key + "\". Check for typos in your " + "XML and make sure that " + "class is part of your Java classpath."), (Throwable)e);
            } else if (e.getCause() instanceof SAXParseException) {
                String systemId = ((SAXParseException)e.getCause()).getSystemId();
                if (StringUtils.endsWith((CharSequence)systemId, (CharSequence)".xsd")) {
                    LOG.error((Object)("XML Schema parsing error for \"" + rootNode.getName() + " -> " + key + "\". Schema: " + systemId), (Throwable)e);
                } else {
                    LOG.error((Object)("XML parsing error for \"" + rootNode.getName() + " -> " + key + "\"."), (Throwable)e);
                }
            }
        } else {
            LOG.debug((Object)("Could not instantiate object from configuration for \"" + rootNode.getName() + " -> " + key + "\"."), (Throwable)e);
        }
    }

    public static Reader newReader(HierarchicalConfiguration node) throws IOException {
        XMLConfiguration xml;
        if (node instanceof XMLConfiguration) {
            xml = (XMLConfiguration)node;
        } else {
            xml = new XMLConfiguration(node);
            XMLConfigurationUtil.disableDelimiterParsing(xml);
        }
        StringWriter w = new StringWriter();
        try {
            xml.save((Writer)w);
        }
        catch (org.apache.commons.configuration.ConfigurationException e) {
            throw new ConfigurationException("Could transform XML node to reader.", e);
        }
        StringReader r = new StringReader(w.toString());
        w.close();
        return r;
    }

    public static int validate(Class<?> clazz, HierarchicalConfiguration node) {
        return XMLConfigurationUtil.doValidate(clazz, node);
    }

    public static int validate(Class<?> clazz, Reader xml) {
        return XMLConfigurationUtil.doValidate(clazz, xml);
    }

    /*
     * Exception decompiling
     */
    private static int doValidate(Class<?> clazz, Object source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void loadFromXML(IXMLConfigurable obj, Reader reader) {
        if (obj == null || reader == null) {
            return;
        }
        XMLConfigurationUtil.loadFromXML(obj, (HierarchicalConfiguration)XMLConfigurationUtil.newXMLConfiguration(reader));
    }

    public static void loadFromXML(IXMLConfigurable obj, HierarchicalConfiguration node) {
        if (obj == null || node == null) {
            return;
        }
        try {
            XMLConfigurationUtil.validate(obj.getClass(), node);
            obj.loadFromXML(XMLConfigurationUtil.newReader(node));
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not load new instance from XML \"" + obj.getClass() + "\".", e);
        }
    }

    public static XMLConfiguration getXmlAt(HierarchicalConfiguration node, String key) {
        if (node == null) {
            return null;
        }
        HierarchicalConfiguration sub = XMLConfigurationUtil.safeConfigurationAt(node, key);
        if (sub == null) {
            return null;
        }
        XMLConfiguration xml = new XMLConfiguration(sub);
        XMLConfigurationUtil.disableDelimiterParsing(xml);
        return xml;
    }

    public static void assertWriteRead(IXMLConfigurable xmlConfiurable) throws IOException {
        XMLConfiguration xml;
        IXMLConfigurable readConfigurable;
        try (StringWriter out = new StringWriter();){
            xmlConfiurable.saveToXML(out);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)out.toString());
        }
        if (!xmlConfiurable.equals(readConfigurable = (IXMLConfigurable)XMLConfigurationUtil.newInstance((HierarchicalConfiguration)(xml = XMLConfigurationUtil.newXMLConfiguration(new StringReader(out.toString())))))) {
            LOG.error((Object)("BEFORE: " + xmlConfiurable));
            LOG.error((Object)(" AFTER: " + readConfigurable));
            throw new ConfigurationException("Saved and loaded XML are not the same.");
        }
    }

    public static BigDecimal getNullableBigDecimal(HierarchicalConfiguration xml, String key, BigDecimal defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getBigDecimal(key, null) : defaultValue;
    }

    public static BigInteger getNullableBigInteger(HierarchicalConfiguration xml, String key, BigInteger defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getBigInteger(key, null) : defaultValue;
    }

    public static Boolean getNullableBoolean(HierarchicalConfiguration xml, String key, Boolean defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getBoolean(key, null) : defaultValue;
    }

    public static Byte getNullableByte(HierarchicalConfiguration xml, String key, Byte defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getByte(key, null) : defaultValue;
    }

    public static Class<?> getNullableClass(HierarchicalConfiguration xml, String key, Class<?> defaultValue) {
        if (!XMLConfigurationUtil.keyExists(xml, key)) {
            return defaultValue;
        }
        String className = xml.getString(key, null);
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Could not create Class: " + className, e);
        }
    }

    public static Double getNullableDouble(HierarchicalConfiguration xml, String key, Double defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getDouble(key, null) : defaultValue;
    }

    public static Float getNullableFloat(HierarchicalConfiguration xml, String key, Float defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getFloat(key, null) : defaultValue;
    }

    public static Integer getNullableInteger(HierarchicalConfiguration xml, String key, Integer defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getInteger(key, null) : defaultValue;
    }

    public static Long getNullableLong(HierarchicalConfiguration xml, String key, Long defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getLong(key, null) : defaultValue;
    }

    public static Short getNullableShort(HierarchicalConfiguration xml, String key, Short defaultValue) {
        return XMLConfigurationUtil.keyExists(xml, key) ? xml.getShort(key, null) : defaultValue;
    }

    public static String getNullableString(HierarchicalConfiguration xml, String key, String defaultValue) {
        if (XMLConfigurationUtil.keyExists(xml, key)) {
            return StringUtils.trimToNull((String)xml.getString(key, null));
        }
        return defaultValue;
    }

    public static Dimension getNullableDimension(HierarchicalConfiguration xml, String key, Dimension defaultValue) {
        if (XMLConfigurationUtil.keyExists(xml, key)) {
            String value = xml.getString(key, null);
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            String[] wh = value.split("[xX]");
            if (wh.length == 1) {
                int val = Integer.parseInt(wh[0].trim());
                return new Dimension(val, val);
            }
            return new Dimension(Integer.parseInt(wh[0].trim()), Integer.parseInt(wh[1].trim()));
        }
        return defaultValue;
    }

    public static boolean keyExists(HierarchicalConfiguration xml, String key) {
        Iterator it = xml.getKeys();
        while (it.hasNext()) {
            String itKey = (String)it.next();
            if (!key.contains("[@")) {
                itKey = itKey.replaceAll("\\[@.*?\\]", "");
            }
            if (!Objects.equals(itKey, key)) continue;
            return true;
        }
        return false;
    }

    public static long getDuration(HierarchicalConfiguration xml, String key, long defaultValue) {
        String duration = xml.getString(key, null);
        if (StringUtils.isBlank((CharSequence)duration)) {
            return defaultValue;
        }
        return DurationParser.parse(duration);
    }

    public static String[] getCSVStringArray(HierarchicalConfiguration xml, String key) {
        return XMLConfigurationUtil.getCSVStringArray(xml, key, null);
    }

    public static String[] getCSVStringArray(HierarchicalConfiguration xml, String key, String[] defaultValues) {
        Object[] values = XMLConfigurationUtil.splitCSV(xml.getString(key, null));
        if (ArrayUtils.isEmpty((Object[])values)) {
            return defaultValues;
        }
        return values;
    }

    public static int[] getCSVIntArray(HierarchicalConfiguration xml, String key) {
        return XMLConfigurationUtil.getCSVIntArray(xml, key, null);
    }

    public static int[] getCSVIntArray(HierarchicalConfiguration xml, String key, int[] defaultValues) {
        Object[] strings = XMLConfigurationUtil.splitCSV(xml.getString(key, null));
        if (ArrayUtils.isEmpty((Object[])strings)) {
            return defaultValues;
        }
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            try {
                ints[i] = Integer.parseInt((String)strings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Invalid integer: " + (String)strings[i]), (Throwable)e);
            }
        }
        return ints;
    }

    private static String[] splitCSV(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return str.trim().split("(\\s*,\\s*)+");
    }

    private static String getXSDResourcePath(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return "/" + clazz.getCanonicalName().replace('.', '/') + ".xsd";
    }

    private static HierarchicalConfiguration safeConfigurationAt(HierarchicalConfiguration node, String key) {
        List subs = node.configurationsAt(key);
        if (subs != null && !subs.isEmpty()) {
            return (HierarchicalConfiguration)subs.get(0);
        }
        return null;
    }

    private static class W3XMLNamespaceFilter
    extends XMLFilterImpl {
        public W3XMLNamespaceFilter(XMLReader parent) {
            super(parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!NamespaceContext.XML_URI.equals(atts.getURI(i))) continue;
                AttributesImpl modifiedAtts = new AttributesImpl(atts);
                modifiedAtts.removeAttribute(i);
                super.startElement(uri, localName, qName, modifiedAtts);
                return;
            }
            super.startElement(uri, localName, qName, atts);
        }
    }

    private static class LogErrorHandler
    implements ErrorHandler {
        private int errorCount = 0;
        private final Class<?> clazz;

        public LogErrorHandler(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            ++this.errorCount;
            LOG.warn((Object)this.msg(e));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            ++this.errorCount;
            LOG.error((Object)this.msg(e));
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            ++this.errorCount;
            LOG.fatal((Object)this.msg(e));
        }

        private String msg(SAXParseException e) {
            return "(XML Validation) " + this.clazz.getSimpleName() + ": " + e.getMessage();
        }

        static /* synthetic */ int access$000(LogErrorHandler x0) {
            return x0.errorCount;
        }
    }
}

