/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.encrypt;

import com.norconex.commons.lang.encrypt.EncryptionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class EncryptionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_KEY_SIZE = 128;
    private final String value;
    private final Integer size;
    private final Source source;

    public EncryptionKey(String value, Source source, int size) {
        this.value = value;
        this.source = source;
        this.size = size;
    }

    public EncryptionKey(String value, Source source) {
        this(value, source, 128);
    }

    public EncryptionKey(String value, int size) {
        this(value, Source.KEY, size);
    }

    public EncryptionKey(String value) {
        this(value, Source.KEY, 128);
    }

    public String getValue() {
        return this.value;
    }

    public Source getSource() {
        return this.source;
    }

    public int getSize() {
        return this.size != null ? this.size : 128;
    }

    public String resolve() {
        if (this.value == null || this.value.trim().length() == 0) {
            return null;
        }
        if (this.source == null) {
            return this.value;
        }
        switch (this.source) {
            case KEY: {
                return this.value;
            }
            case FILE: {
                return this.fromFile();
            }
            case ENVIRONMENT: {
                return this.fromEnv();
            }
            case PROPERTY: {
                return this.fromProperty();
            }
        }
        return null;
    }

    private String fromEnv() {
        return System.getenv(this.value);
    }

    private String fromProperty() {
        return System.getProperty(this.value);
    }

    private String fromFile() {
        File file = new File(this.value);
        if (!file.isFile()) {
            throw new EncryptionException("Key file is not a file or does not exists: " + file.getAbsolutePath());
        }
        try {
            return new String(Files.readAllBytes(Paths.get(this.value, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new EncryptionException("Could not read key file.", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey other = (EncryptionKey)obj;
        if (this.source != other.source) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.size == null ? other.size != null : !this.size.equals(other.size));
    }

    public String toString() {
        return "EncryptionKey [value=" + this.value + ", source=" + (Object)((Object)this.source) + ", size=" + this.size + "]";
    }

    public static enum Source {
        KEY,
        FILE,
        ENVIRONMENT,
        PROPERTY;

    }
}

