/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.encrypt;

import com.norconex.commons.lang.encrypt.EncryptionException;
import com.norconex.commons.lang.encrypt.EncryptionKey;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class EncryptionUtil {
    private EncryptionUtil() {
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            EncryptionUtil.printUsage();
        }
        String cmdArg = args[0];
        String typeArg = args[1];
        String keyArg = args[2];
        String textArg = args[3];
        EncryptionKey.Source type = null;
        if ("-k".equalsIgnoreCase(typeArg)) {
            type = EncryptionKey.Source.KEY;
        } else if ("-f".equalsIgnoreCase(typeArg)) {
            type = EncryptionKey.Source.FILE;
        } else if ("-e".equalsIgnoreCase(typeArg)) {
            type = EncryptionKey.Source.ENVIRONMENT;
        } else if ("-p".equalsIgnoreCase(typeArg)) {
            type = EncryptionKey.Source.PROPERTY;
        } else {
            System.err.println("Unsupported type of key: " + (Object)((Object)type));
            EncryptionUtil.printUsage();
        }
        EncryptionKey key = new EncryptionKey(keyArg, type);
        if ("encrypt".equalsIgnoreCase(cmdArg)) {
            System.out.println(EncryptionUtil.encrypt(textArg, key));
        } else if ("decrypt".equalsIgnoreCase(cmdArg)) {
            System.out.println(EncryptionUtil.decrypt(textArg, key));
        } else {
            System.err.println("Unsupported command: " + cmdArg);
            EncryptionUtil.printUsage();
        }
        System.exit(0);
    }

    private static void printUsage() {
        PrintStream out = System.out;
        out.println("<appName> encrypt|decrypt -k|-f|-e|-p key text");
        out.println();
        out.println("Where:");
        out.println("  encrypt  encrypt the text with the given key");
        out.println("  decrypt  decrypt the text with the given key");
        out.println("  -k       key is the encryption key");
        out.println("  -f       key is the file containing the encryption key");
        out.println("  -e       key is the environment variable holding the encryption key");
        out.println("  -p       key is the system property holding the encryption key");
        out.println("  key      the encryption key (or file, or env. variable, etc.)");
        out.println("  text     text to encrypt or decrypt");
        System.exit(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encrypt(String textToEncrypt, EncryptionKey encryptionKey) {
        if (textToEncrypt == null) {
            return null;
        }
        if (encryptionKey == null) {
            return textToEncrypt;
        }
        String key = encryptionKey.resolve();
        if (key == null) {
            return textToEncrypt;
        }
        byte[] salt = new byte[]{-29, 3, -101, -87, -56, 22, 53, 86};
        int iterationCount = 1000;
        int keySize = encryptionKey.getSize();
        try {
            PBEKeySpec keySpec = new PBEKeySpec(key.trim().toCharArray(), salt, iterationCount, keySize);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey secretKeyTemp = factory.generateSecret(keySpec);
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyTemp.getEncoded(), "AES");
            Cipher ecipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            ecipher.init(1, secretKey);
            AlgorithmParameters params = ecipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] utf8 = textToEncrypt.trim().getBytes(StandardCharsets.UTF_8);
            byte[] cipherBytes = ecipher.doFinal(utf8);
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                bos.write(iv);
                bos.write(cipherBytes);
                String string = DatatypeConverter.printBase64Binary((byte[])bos.toByteArray());
                return string;
            }
        }
        catch (Exception e) {
            throw new EncryptionException("Encryption failed.", e);
        }
    }

    public static String decrypt(String encryptedText, EncryptionKey encryptionKey) {
        if (encryptedText == null) {
            return null;
        }
        if (encryptionKey == null) {
            return encryptedText;
        }
        String key = encryptionKey.resolve();
        if (key == null) {
            return encryptedText;
        }
        byte[] salt = new byte[]{-29, 3, -101, -87, -56, 22, 53, 86};
        int iterationCount = 1000;
        int keySize = encryptionKey.getSize();
        try {
            byte[] cryptMessage = DatatypeConverter.parseBase64Binary((String)encryptedText.trim());
            byte[] iv = Arrays.copyOf(cryptMessage, 16);
            byte[] cryptBytes = Arrays.copyOfRange(cryptMessage, 16, cryptMessage.length);
            PBEKeySpec keySpec = new PBEKeySpec(key.trim().toCharArray(), salt, iterationCount, keySize);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey secretKeyTemp = factory.generateSecret(keySpec);
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyTemp.getEncoded(), "AES");
            IvParameterSpec ivParamSpec = new IvParameterSpec(iv);
            Cipher dcipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            dcipher.init(2, (Key)secretKey, ivParamSpec);
            byte[] utf8 = dcipher.doFinal(cryptBytes);
            return new String(utf8, StandardCharsets.UTF_8);
        }
        catch (Exception original) {
            try {
                return EncryptionUtil.decryptLegacy(encryptedText, key);
            }
            catch (GeneralSecurityException subsequent) {
                throw new EncryptionException("Decryption failed.", original);
            }
        }
    }

    private static String decryptLegacy(String encryptedText, String key) throws GeneralSecurityException {
        byte[] salt = new byte[]{-29, 3, -101, -87, -56, 22, 53, 86};
        int iterationCount = 19;
        PBEKeySpec keySpec = new PBEKeySpec(key.trim().toCharArray(), salt, iterationCount);
        SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
        Cipher dcipher = Cipher.getInstance(secretKey.getAlgorithm());
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
        dcipher.init(2, (Key)secretKey, paramSpec);
        byte[] dec = DatatypeConverter.parseBase64Binary((String)encryptedText.trim());
        return new String(dcipher.doFinal(dec), StandardCharsets.UTF_8);
    }
}

