/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.encrypt;

import com.norconex.commons.lang.config.XMLConfigurationUtil;
import com.norconex.commons.lang.encrypt.EncryptionKey;
import com.norconex.commons.lang.xml.EnhancedXMLStreamWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;

public class EncryptionXMLUtil {
    private EncryptionXMLUtil() {
    }

    public static EncryptionKey loadFromXML(Reader in, String tagPrefix, EncryptionKey defaultKey) {
        XMLConfiguration xml = XMLConfigurationUtil.newXMLConfiguration(in);
        return EncryptionXMLUtil.loadFromXML(xml, tagPrefix, defaultKey);
    }

    public static EncryptionKey loadFromXML(XMLConfiguration xml, String tagPrefix, EncryptionKey defaultKey) {
        String tagKey = StringUtils.trimToEmpty((String)tagPrefix);
        tagKey = tagKey.length() > 0 ? tagKey + "Key" : "key";
        String tagSource = tagKey + "Source";
        String tagSize = tagKey + "Size";
        String xmlKey = xml.getString(tagKey, null);
        if (StringUtils.isNotBlank((CharSequence)xmlKey)) {
            String xmlSource = xml.getString(tagSource, null);
            Integer size = xml.getInteger(tagSize, Integer.valueOf(128));
            EncryptionKey.Source source = null;
            if (StringUtils.isNotBlank((CharSequence)xmlSource)) {
                source = EncryptionKey.Source.valueOf(xmlSource.toUpperCase());
            }
            return new EncryptionKey(xmlKey, source, size);
        }
        return defaultKey;
    }

    public static void saveToXML(Writer writer, String tagPrefix, EncryptionKey encryptionKey) throws IOException {
        try {
            EncryptionXMLUtil.saveToXML(new EnhancedXMLStreamWriter(writer), tagPrefix, encryptionKey);
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot save as XML.", e);
        }
    }

    public static void saveToXML(XMLStreamWriter writer, String tagPrefix, EncryptionKey encryptionKey) throws IOException {
        String tagKey = StringUtils.trimToEmpty((String)tagPrefix);
        tagKey = tagKey.length() > 0 ? tagKey + "Key" : "key";
        String tagSource = tagKey + "Source";
        String tagSize = tagKey + "Size";
        try {
            EnhancedXMLStreamWriter w = null;
            w = writer instanceof EnhancedXMLStreamWriter ? (EnhancedXMLStreamWriter)writer : new EnhancedXMLStreamWriter(writer);
            if (encryptionKey != null) {
                w.writeElementString(tagKey, encryptionKey.getValue());
                w.writeElementInteger(tagSize, encryptionKey.getSize());
                if (encryptionKey.getSource() != null) {
                    w.writeElementString(tagSource, encryptionKey.getSource().name().toLowerCase());
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Cannot save as XML.", e);
        }
    }
}

