/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.exec;

import com.norconex.commons.lang.exec.ExecException;
import com.norconex.commons.lang.io.IInputStreamListener;
import com.norconex.commons.lang.io.InputStreamConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class ExecUtil {
    public static final String STDOUT = "STDOUT";
    public static final String STDERR = "STDERR";

    private ExecUtil() {
    }

    public static int watchProcess(Process process) {
        return ExecUtil.watchProcess(process, new IInputStreamListener[0], new IInputStreamListener[0]);
    }

    public static int watchProcess(Process process, IInputStreamListener listener) {
        return ExecUtil.watchProcess(process, new IInputStreamListener[]{listener}, new IInputStreamListener[]{listener});
    }

    public static int watchProcess(Process process, IInputStreamListener[] listeners) {
        return ExecUtil.watchProcess(process, listeners, listeners);
    }

    public static int watchProcess(Process process, IInputStreamListener outputListener, IInputStreamListener errorListener) throws InterruptedException {
        return ExecUtil.watchProcess(process, new IInputStreamListener[]{outputListener}, new IInputStreamListener[]{errorListener});
    }

    public static int watchProcess(Process process, IInputStreamListener[] outputListeners, IInputStreamListener[] errorListeners) {
        return ExecUtil.watchProcess(process, null, outputListeners, errorListeners);
    }

    public static int watchProcess(Process process, InputStream input, IInputStreamListener[] outputListeners, IInputStreamListener[] errorListeners) {
        ExecUtil.watchProcessAsync(process, input, outputListeners, errorListeners);
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new ExecException("Process was interrupted.", e);
        }
    }

    public static void watchProcessAsync(Process process, IInputStreamListener outputListener, IInputStreamListener errorListener) {
        ExecUtil.watchProcessAsync(process, new IInputStreamListener[]{outputListener}, new IInputStreamListener[]{errorListener});
    }

    public static void watchProcessAsync(Process process, IInputStreamListener[] outputListeners, IInputStreamListener[] errorListeners) {
        ExecUtil.watchProcessAsync(process, null, outputListeners, errorListeners);
    }

    public static void watchProcessAsync(final Process process, final InputStream input, IInputStreamListener[] outputListeners, IInputStreamListener[] errorListeners) {
        InputStreamConsumer output = new InputStreamConsumer(process.getInputStream(), STDOUT, outputListeners);
        output.start();
        InputStreamConsumer error = new InputStreamConsumer(process.getErrorStream(), STDERR, errorListeners);
        error.start();
        if (input != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try (OutputStream stdin = process.getOutputStream();){
                        IOUtils.copy((InputStream)input, (OutputStream)stdin);
                    }
                    catch (IOException e) {
                        throw new ExecException("Error sending input stream to proces.", e);
                    }
                }
            };
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new ExecException("Process interrupted while sending input stream.", e);
            }
        }
    }
}

