/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.exec;

import com.norconex.commons.lang.Sleeper;
import com.norconex.commons.lang.exec.IExceptionFilter;
import com.norconex.commons.lang.exec.IRetriable;
import com.norconex.commons.lang.exec.RetriableException;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Retrier {
    private static final Logger LOG = LogManager.getLogger(Retrier.class);
    public static final int DEFAULT_MAX_RETRIES = 10;
    public static final long DEFAULT_RETRY_DELAY = 0L;
    public static final int DEFAULT_MAX_CAUSES_KEPT = 10;
    private static final Exception[] EMPTY_EXCEPTIONS = new Exception[0];
    private int maxRetries = 10;
    private long retryDelay = 0L;
    private IExceptionFilter exceptionFilter;
    private int maxCauses = 10;

    public Retrier() {
    }

    public Retrier(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Retrier(IExceptionFilter exceptionFilter) {
        this.exceptionFilter = exceptionFilter;
    }

    public Retrier(IExceptionFilter exceptionFilter, int maxRetries) {
        this.maxRetries = maxRetries;
        this.exceptionFilter = exceptionFilter;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Retrier setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public Retrier setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public IExceptionFilter getExceptionFilter() {
        return this.exceptionFilter;
    }

    public Retrier setExceptionFilter(IExceptionFilter exceptionFilter) {
        this.exceptionFilter = exceptionFilter;
        return this;
    }

    public int getMaxCauses() {
        return this.maxCauses;
    }

    public Retrier setMaxCauses(int maxCauses) {
        this.maxCauses = maxCauses;
        return this;
    }

    public <T> T execute(IRetriable<T> retriable) throws RetriableException {
        int attemptCount = 0;
        CircularFifoQueue exceptions = new CircularFifoQueue(this.maxCauses);
        while (attemptCount <= this.maxRetries) {
            try {
                return retriable.execute();
            }
            catch (Exception e) {
                exceptions.add((Object)e);
                if (this.exceptionFilter != null && !this.exceptionFilter.retry(e)) {
                    throw new RetriableException("Encountered an exception preventing execution retry.", (Throwable[])exceptions.toArray((Object[])EMPTY_EXCEPTIONS));
                }
                if (++attemptCount >= this.maxRetries) continue;
                LOG.warn((Object)("Execution failed, retrying (" + attemptCount + " of " + this.maxRetries + " maximum retries)."), (Throwable)exceptions.get(exceptions.size() - 1));
                Sleeper.sleepMillis(this.retryDelay);
            }
        }
        throw new RetriableException("Execution failed, maximum number of retries reached.", (Throwable[])exceptions.toArray((Object[])EMPTY_EXCEPTIONS));
    }
}

