/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.exec;

import com.norconex.commons.lang.exec.ExecUtil;
import com.norconex.commons.lang.exec.SystemCommandException;
import com.norconex.commons.lang.io.IInputStreamListener;
import com.norconex.commons.lang.io.InputStreamLineListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SystemCommand {
    private static final Logger LOG = LogManager.getLogger(SystemCommand.class);
    private static final String[] CMD_PREFIXES_WIN_LEGACY = new String[]{"command.com", "/C"};
    private static final String[] CMD_PREFIXES_WIN_CURRENT = new String[]{"cmd.exe", "/C"};
    private static final IInputStreamListener[] EMPTY_LISTENERS = new IInputStreamListener[0];
    private final String[] command;
    private final File workdir;
    private Map<String, String> environmentVariables = null;
    private final List<IInputStreamListener> errorListeners = Collections.synchronizedList(new ArrayList());
    private final List<IInputStreamListener> outputListeners = Collections.synchronizedList(new ArrayList());
    private Process process;

    public SystemCommand(String ... command) {
        this((File)null, command);
    }

    public SystemCommand(File workdir, String ... command) {
        this.command = command;
        this.workdir = workdir;
    }

    public String[] getCommand() {
        return (String[])ArrayUtils.clone((Object[])this.command);
    }

    public File getWorkdir() {
        return this.workdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(IInputStreamListener listener) {
        List<IInputStreamListener> list = this.errorListeners;
        synchronized (list) {
            this.errorListeners.add(0, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(IInputStreamListener listener) {
        List<IInputStreamListener> list = this.errorListeners;
        synchronized (list) {
            this.errorListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputListener(IInputStreamListener listener) {
        List<IInputStreamListener> list = this.outputListeners;
        synchronized (list) {
            this.outputListeners.add(0, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputListener(IInputStreamListener listener) {
        List<IInputStreamListener> list = this.outputListeners;
        synchronized (list) {
            this.outputListeners.remove(listener);
        }
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public void abort() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public int execute() throws SystemCommandException {
        return this.execute(false);
    }

    public int execute(boolean runInBackground) throws SystemCommandException {
        return this.execute(null, runInBackground);
    }

    public int execute(InputStream input) throws SystemCommandException {
        return this.execute(input, false);
    }

    public int execute(InputStream input, boolean runInBackground) throws SystemCommandException {
        if (this.isRunning()) {
            throw new IllegalStateException("Command is already running: " + this.toString());
        }
        Object[] cleanCommand = this.getCleanCommand();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing command: " + StringUtils.join((Object[])cleanCommand, (String)" ")));
        }
        try {
            this.process = Runtime.getRuntime().exec((String[])cleanCommand, this.environmentArray(), this.workdir);
        }
        catch (IOException e) {
            throw new SystemCommandException("Could not execute command: " + this.toString(), e);
        }
        IInputStreamListener[] outListeners = this.outputListeners.toArray(EMPTY_LISTENERS);
        Object[] errListeners = this.errorListeners.toArray(EMPTY_LISTENERS);
        ErrorTracker errorTracker = new ErrorTracker();
        errListeners = (IInputStreamListener[])ArrayUtils.add((Object[])errListeners, (Object)errorTracker);
        int exitValue = 0;
        if (runInBackground) {
            ExecUtil.watchProcessAsync(this.process, input, outListeners, (IInputStreamListener[])errListeners);
            try {
                exitValue = this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        } else {
            exitValue = ExecUtil.watchProcess(this.process, input, outListeners, (IInputStreamListener[])errListeners);
        }
        if (exitValue != 0) {
            LOG.error((Object)("Command returned with exit value " + this.process.exitValue() + " (command properly escaped?). Command: " + StringUtils.join((Object[])cleanCommand, (String)" ") + " Error: \"" + errorTracker.b.toString() + "\""));
        }
        this.process = null;
        return exitValue;
    }

    public String toString() {
        return StringUtils.join((Object[])this.command, (String)" ");
    }

    private String[] environmentArray() {
        if (this.environmentVariables == null) {
            return null;
        }
        ArrayList<String> envs = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.environmentVariables.entrySet()) {
            envs.add(entry.getKey() + "=" + entry.getValue());
        }
        return envs.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private String[] getCleanCommand() throws SystemCommandException {
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(ArrayUtils.nullToEmpty((String[])this.command)));
        if (cmd.isEmpty()) {
            throw new SystemCommandException("No command specified.");
        }
        SystemCommand.escape(cmd);
        this.wrapCommand(cmd);
        return cmd.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private void removePrefixes(List<String> cmd, String[] prefixes) {
        if (ArrayUtils.isEmpty((Object[])prefixes) || cmd.isEmpty()) {
            return;
        }
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = prefixes[i];
            if (cmd.size() <= i || !prefix.equalsIgnoreCase(cmd.get(0))) {
                return;
            }
            cmd.remove(0);
        }
    }

    public static void escape(List<String> command) {
        SystemCommand.escapeWindows(command);
    }

    public static String[] escape(String ... command) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(command));
        SystemCommand.escape(list);
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private static void escapeWindows(List<String> cmd) {
        if (cmd.size() == 1) {
            String cmdLine = cmd.get(0);
            cmd.clear();
            cmd.addAll(Arrays.asList(SystemCommand.translateCommandline(cmdLine)));
        }
        ArrayList<String> newCmd = new ArrayList<String>();
        for (String arg : cmd) {
            if (StringUtils.contains((CharSequence)arg, (int)32) && !arg.matches("^\\s*\".*\"\\s*$")) {
                newCmd.add('\"' + arg + '\"');
                continue;
            }
            newCmd.add(arg);
        }
        cmd.clear();
        cmd.addAll(newCmd);
    }

    private void wrapCommand(List<String> cmd) {
        if (SystemUtils.OS_NAME == null || !SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        String[] prefixes = SystemUtils.IS_OS_WINDOWS_95 || SystemUtils.IS_OS_WINDOWS_98 || SystemUtils.IS_OS_WINDOWS_ME ? CMD_PREFIXES_WIN_LEGACY : CMD_PREFIXES_WIN_CURRENT;
        this.removePrefixes(cmd, prefixes);
        String wrappedCmd = "\"" + StringUtils.join(cmd, (String)" ") + "\"";
        cmd.clear();
        cmd.addAll(Arrays.asList(prefixes));
        cmd.add(wrappedCmd);
    }

    private static String[] translateCommandline(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    private class ErrorTracker
    extends InputStreamLineListener {
        private final StringBuilder b = new StringBuilder();

        private ErrorTracker() {
        }

        @Override
        protected void lineStreamed(String type, String line) {
            if (this.b.length() > 0) {
                this.b.append('\n');
            }
            this.b.append(line);
        }
    }
}

