/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.file;

import com.norconex.commons.lang.file.ContentType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class ContentFamily {
    private static final Logger LOG = LogManager.getLogger(ContentFamily.class);
    private static final ResourceBundle BUNDLE_MAPPINGS;
    private static final Map<String, String> WILD_MAPPINGS;
    private static final Map<String, ContentFamily> FAMILIES;
    private static final Map<Locale, ResourceBundle> BUNDLE_DISPLAYNAMES;
    private final String id;

    private ContentFamily(String id) {
        this.id = id;
    }

    public static ContentFamily valueOf(String familyId) {
        ContentFamily family = FAMILIES.get(familyId);
        if (family == null) {
            family = new ContentFamily(familyId);
            FAMILIES.put(familyId, family);
        }
        return family;
    }

    public static ContentFamily forContentType(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        return ContentFamily.forContentType(contentType.toString());
    }

    public static ContentFamily forContentType(String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return null;
        }
        String familyId = null;
        String cleanType = StringUtils.substringBefore((String)contentType, (String)";");
        if (BUNDLE_MAPPINGS.containsKey(cleanType)) {
            familyId = BUNDLE_MAPPINGS.getString(cleanType);
        }
        if (familyId == null) {
            for (Map.Entry<String, String> entry : WILD_MAPPINGS.entrySet()) {
                String partialContentType = entry.getKey();
                if (!cleanType.startsWith(partialContentType)) continue;
                familyId = entry.getValue();
                break;
            }
        }
        return ContentFamily.valueOf(familyId);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        Locale safeLocale = locale;
        if (safeLocale == null) {
            safeLocale = Locale.getDefault();
        }
        try {
            return this.getDisplayBundle(safeLocale).getString(this.id);
        }
        catch (MissingResourceException e) {
            LOG.debug((Object)("Could not find display name for content family: " + this.id));
            return "[" + this.id + "]";
        }
    }

    private ResourceBundle getDisplayBundle(Locale locale) {
        ResourceBundle bundle = BUNDLE_DISPLAYNAMES.get(locale);
        if (bundle != null) {
            return bundle;
        }
        try {
            bundle = ResourceBundle.getBundle(ContentFamily.class.getSimpleName() + "-custom-names", locale);
        }
        catch (MissingResourceException e) {
            bundle = ResourceBundle.getBundle(ContentFamily.class.getName() + "-names", locale);
        }
        BUNDLE_DISPLAYNAMES.put(locale, bundle);
        return bundle;
    }

    public boolean contains(ContentType contentType) {
        if (contentType == null) {
            return false;
        }
        return this.contains(contentType.toString());
    }

    public boolean contains(String contentType) {
        ContentFamily family = ContentFamily.forContentType(contentType);
        return family == this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentFamily other = (ContentFamily)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getId();
    }

    static {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(ContentFamily.class.getSimpleName() + "-custom-mappings");
        }
        catch (MissingResourceException e) {
            bundle = ResourceBundle.getBundle(ContentFamily.class.getName() + "-mappings");
        }
        BUNDLE_MAPPINGS = bundle;
        WILD_MAPPINGS = new ListOrderedMap();
        FAMILIES = new HashMap<String, ContentFamily>();
        for (String contentType : BUNDLE_MAPPINGS.keySet()) {
            String familyId = BUNDLE_MAPPINGS.getString(contentType);
            if (!contentType.startsWith("DEFAULT")) continue;
            String partialContentType = contentType.replaceFirst("DEFAULT\\.{0,1}", "");
            WILD_MAPPINGS.put(partialContentType, familyId);
        }
        BUNDLE_DISPLAYNAMES = new HashMap<Locale, ResourceBundle>();
    }
}

