/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.file;

import com.norconex.commons.lang.file.ContentFamily;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class ContentType
implements Serializable {
    private static final long serialVersionUID = 6416074869536512030L;
    private static final Logger LOG = LogManager.getLogger(ContentType.class);
    private static final Map<String, ContentType> REGISTRY = new HashMap<String, ContentType>();
    private static final ResourceBundle BUNDLE_EXTENSIONS;
    private static final Map<Locale, ResourceBundle> BUNDLE_DISPLAYNAMES;
    public static final ContentType TEXT;
    public static final ContentType HTML;
    public static final ContentType PDF;
    public static final ContentType XML;
    public static final ContentType CSV;
    public static final ContentType TSV;
    public static final ContentType ZIP;
    public static final ContentType JPEG;
    public static final ContentType GIF;
    public static final ContentType BMP;
    public static final ContentType PNG;
    private final String type;

    private ContentType(String contentType) {
        this.type = contentType;
        REGISTRY.put(contentType, this);
    }

    public static ContentType valueOf(String contentType) {
        String trimmedType = StringUtils.trim((String)contentType);
        if (StringUtils.isBlank((CharSequence)trimmedType)) {
            return null;
        }
        ContentType type = REGISTRY.get(trimmedType);
        if (type != null) {
            return type;
        }
        return new ContentType(trimmedType);
    }

    public static ContentType[] valuesOf(String ... contentTypes) {
        if (!ArrayUtils.isEmpty((Object[])contentTypes)) {
            ContentType[] cts = new ContentType[contentTypes.length];
            for (int i = 0; i < contentTypes.length; ++i) {
                String ctString = contentTypes[i];
                cts[i] = ContentType.valueOf(ctString);
            }
            return cts;
        }
        return new ContentType[0];
    }

    public String getDisplayName() {
        return this.getDisplayName(null);
    }

    public String getDisplayName(Locale locale) {
        Locale safeLocale = locale;
        if (safeLocale == null) {
            safeLocale = Locale.getDefault();
        }
        try {
            return this.getDisplayBundle(safeLocale).getString(this.toBaseTypeString());
        }
        catch (MissingResourceException e) {
            LOG.debug((Object)("Could not find display name for content type: " + this.type));
            return "[" + this.type + "]";
        }
    }

    private ResourceBundle getDisplayBundle(Locale locale) {
        ResourceBundle bundle = BUNDLE_DISPLAYNAMES.get(locale);
        if (bundle != null) {
            return bundle;
        }
        try {
            bundle = ResourceBundle.getBundle(ContentType.class.getSimpleName() + "-custom-names", locale);
        }
        catch (MissingResourceException e) {
            bundle = ResourceBundle.getBundle(ContentType.class.getName() + "-names", locale);
        }
        BUNDLE_DISPLAYNAMES.put(locale, bundle);
        return bundle;
    }

    public ContentFamily getContentFamily() {
        return ContentFamily.forContentType(this.type);
    }

    public String getExtension() {
        String[] exts = this.getExtensions();
        if (exts == null || exts.length == 0) {
            return "";
        }
        return exts[0];
    }

    public String[] getExtensions() {
        try {
            String ext = BUNDLE_EXTENSIONS.getString(this.toBaseTypeString());
            return StringUtils.split((String)ext, (char)',');
        }
        catch (MissingResourceException e) {
            LOG.debug((Object)("Could not find extension(s) for content type: " + this.type));
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
    }

    public boolean matches(String contentType) {
        return this.type.equals(StringUtils.trim((String)contentType));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return this.type;
    }

    public String toBaseTypeString() {
        return StringUtils.substringBefore((String)this.type, (String)";");
    }

    public ContentType toBaseType() {
        if (this.type.contains(";")) {
            return ContentType.valueOf(this.toBaseTypeString());
        }
        return this;
    }

    static {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(ContentType.class.getSimpleName() + "-custom-extensions");
        }
        catch (MissingResourceException e) {
            bundle = ResourceBundle.getBundle(ContentType.class.getName() + "-extensions");
        }
        BUNDLE_EXTENSIONS = bundle;
        BUNDLE_DISPLAYNAMES = new HashMap<Locale, ResourceBundle>();
        TEXT = new ContentType("text/plain");
        HTML = new ContentType("text/html");
        PDF = new ContentType("application/pdf");
        XML = new ContentType("application/xml");
        CSV = new ContentType("text/csv");
        TSV = new ContentType("text/tab-separated-values");
        ZIP = new ContentType("application/zip");
        JPEG = new ContentType("image/jpeg");
        GIF = new ContentType("image/gif");
        BMP = new ContentType("image/bmp");
        PNG = new ContentType("image/png");
    }
}

