/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.file;

import com.norconex.commons.lang.file.IFileChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class FileMonitor {
    private static final FileMonitor INSTANCE = new FileMonitor();
    private Timer timer = new Timer(true);
    private Map<String, FileMonitorTask> timerEntries = new Hashtable<String, FileMonitorTask>();

    private FileMonitor() {
    }

    public static FileMonitor getInstance() {
        return INSTANCE;
    }

    public void addFileChangeListener(IFileChangeListener listener, String fileName, long period) throws FileNotFoundException {
        this.addFileChangeListener(listener, new File(fileName), period);
    }

    public void addFileChangeListener(IFileChangeListener listener, File file, long period) throws FileNotFoundException {
        this.removeFileChangeListener(listener, file);
        FileMonitorTask task = new FileMonitorTask(listener, file);
        this.timerEntries.put(file.toString() + listener.hashCode(), task);
        this.timer.schedule((TimerTask)task, period, period);
    }

    public void removeFileChangeListener(IFileChangeListener listener, String fileName) {
        this.removeFileChangeListener(listener, new File(fileName));
    }

    public void removeFileChangeListener(IFileChangeListener listener, File file) {
        FileMonitorTask task = this.timerEntries.remove(file.toString() + listener.hashCode());
        if (task != null) {
            task.cancel();
        }
    }

    protected void fireFileChangeEvent(IFileChangeListener listener, File file) {
        listener.fileChanged(file);
    }

    class FileMonitorTask
    extends TimerTask {
        private IFileChangeListener listener;
        private File monitoredFile;
        private long lastModified;

        public FileMonitorTask(IFileChangeListener listener, File file) throws FileNotFoundException {
            this.listener = listener;
            this.lastModified = 0L;
            this.monitoredFile = file;
            if (!this.monitoredFile.exists()) {
                URL fileURL = listener.getClass().getClassLoader().getResource(file.toString());
                if (fileURL != null) {
                    this.monitoredFile = new File(fileURL.getFile());
                } else {
                    throw new FileNotFoundException("File Not Found: " + file);
                }
            }
            this.lastModified = this.monitoredFile.lastModified();
        }

        @Override
        public void run() {
            long fileLastModified = this.monitoredFile.lastModified();
            if (fileLastModified != this.lastModified) {
                this.lastModified = fileLastModified;
                FileMonitor.this.fireFileChangeEvent(this.listener, this.monitoredFile);
            }
        }
    }
}

