/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.lang3.ArrayUtils;

public class ByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private final List<byte[]> buffers = new ArrayList<byte[]>();
    private int currentBufferIndex;
    private int totalCount;
    private byte[] currentBuffer;
    private final int bufferCapacity;

    public ByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            this.bufferCapacity = size;
            this.addNewBuffer();
        }
    }

    private void addNewBuffer() {
        this.currentBuffer = new byte[this.bufferCapacity];
        this.buffers.add(this.currentBuffer);
        this.currentBufferIndex = 0;
    }

    public int getByte(int offset) {
        int pos = Math.max(0, offset);
        if (pos >= this.totalCount) {
            return -1;
        }
        int buffersIndex = pos / this.bufferCapacity;
        int bufPos = pos % this.bufferCapacity;
        return this.buffers.get(buffersIndex)[bufPos];
    }

    public int getBytes(byte[] target, int offset) {
        int thisLengthToRead;
        if (target == null) {
            throw new IllegalArgumentException("Target byte array cannot be null.");
        }
        int thisStartOffset = Math.max(0, offset);
        if (thisStartOffset >= this.totalCount) {
            return -1;
        }
        int sourceBytesLeftToRead = thisLengthToRead = Math.min(target.length, this.totalCount - thisStartOffset);
        int sourceOffset = thisStartOffset;
        int targetOffset = 0;
        while (sourceBytesLeftToRead > 0) {
            byte[] sliceBuffer = this.buffers.get(sourceOffset / this.bufferCapacity);
            int sliceOffset = sourceOffset % this.bufferCapacity;
            int lengthToRead = sourceBytesLeftToRead > this.bufferCapacity - sliceOffset ? this.bufferCapacity - sliceOffset : sourceBytesLeftToRead;
            System.arraycopy(sliceBuffer, sliceOffset, target, targetOffset, lengthToRead);
            sourceBytesLeftToRead -= lengthToRead;
            sourceOffset += lengthToRead;
            targetOffset += lengthToRead;
        }
        return thisLengthToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = this;
        synchronized (byteArrayOutputStream) {
            int bytesLeftToWrite = len;
            int lastOff = off;
            while (bytesLeftToWrite > 0) {
                int currentRoomLeft = this.bufferCapacity - this.currentBufferIndex;
                int lengthToWrite = Math.min(bytesLeftToWrite, currentRoomLeft);
                System.arraycopy(b, lastOff, this.currentBuffer, this.currentBufferIndex, lengthToWrite);
                this.currentBufferIndex += lengthToWrite;
                lastOff += lengthToWrite;
                bytesLeftToWrite -= lengthToWrite;
                if (this.currentBufferIndex == this.bufferCapacity) {
                    this.addNewBuffer();
                }
                this.totalCount += lengthToWrite;
            }
        }
    }

    @Override
    public synchronized void write(int b) {
        this.currentBuffer[this.currentBufferIndex] = (byte)b;
        ++this.totalCount;
        ++this.currentBufferIndex;
        if (this.currentBufferIndex == this.bufferCapacity) {
            this.addNewBuffer();
        }
    }

    public synchronized int write(InputStream in) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        int readCount = 0;
        while ((length = in.read(buffer)) != -1) {
            readCount += length;
            this.write(buffer, 0, length);
        }
        return readCount;
    }

    public synchronized int size() {
        return this.totalCount;
    }

    @Override
    public void close() throws IOException {
    }

    public synchronized void reset() {
        this.totalCount = 0;
        this.buffers.clear();
        this.addNewBuffer();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        int remaining = this.totalCount;
        for (byte[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            out.write(buf, 0, c);
            if ((remaining -= c) != 0) continue;
            break;
        }
    }

    public static InputStream toBufferedInputStream(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(input);
        IOUtils.closeQuietly((InputStream)input);
        return output.toBufferedInputStream();
    }

    private InputStream toBufferedInputStream() {
        int remaining = this.totalCount;
        if (remaining == 0) {
            return new ClosedInputStream();
        }
        ArrayList<ByteArrayInputStream> list = new ArrayList<ByteArrayInputStream>(this.buffers.size());
        for (byte[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            list.add(new ByteArrayInputStream(buf, 0, c));
            if ((remaining -= c) != 0) continue;
            break;
        }
        return new SequenceInputStream(Collections.enumeration(list));
    }

    public synchronized byte[] toByteArray() {
        int remaining = this.totalCount;
        if (remaining == 0) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] newbuf = new byte[remaining];
        int pos = 0;
        for (byte[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, newbuf, pos, c);
            pos += c;
            if ((remaining -= c) != 0) continue;
            break;
        }
        return newbuf;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), enc);
    }
}

