/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int b = this.buf.get() & 0xFF;
        if (b == 0) {
            return -1;
        }
        return b;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int newLen = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, newLen);
        if (newLen < len) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                return i;
            }
        }
        return newLen;
    }
}

