/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.file.FileUtil;
import com.norconex.commons.lang.io.ByteArrayOutputStream;
import com.norconex.commons.lang.io.CachedStreamFactory;
import com.norconex.commons.lang.io.ICachedStream;
import com.norconex.commons.lang.io.StreamException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CachedInputStream
extends InputStream
implements ICachedStream {
    private static final Logger LOG = LogManager.getLogger(CachedInputStream.class);
    private static final int UNDEFINED_LENGTH = -42;
    private final CachedStreamFactory factory;
    private final CachedStreamFactory.MemoryTracker tracker;
    private InputStream inputStream;
    private byte[] memCache;
    private ByteArrayOutputStream memOutputStream;
    private File fileCache;
    private RandomAccessFile randomAccessFile;
    private boolean firstRead = true;
    private boolean needNewStream = false;
    private boolean cacheEmpty = true;
    private boolean disposed = false;
    private final File cacheDirectory;
    private int count;
    private int pos = 0;
    private int markpos = -1;
    private int length = -42;

    CachedInputStream(CachedStreamFactory factory, File cacheDirectory, InputStream is) {
        this.factory = factory;
        this.tracker = new CachedStreamFactory.MemoryTracker(factory);
        this.memOutputStream = new ByteArrayOutputStream();
        this.inputStream = is instanceof BufferedInputStream ? is : new BufferedInputStream(is);
        this.cacheDirectory = CachedInputStream.nullSafeCacheDirectory(cacheDirectory);
    }

    CachedInputStream(CachedStreamFactory factory, File cacheDirectory, byte[] memCache) {
        this.factory = factory;
        this.tracker = new CachedStreamFactory.MemoryTracker(factory);
        this.memCache = ArrayUtils.clone((byte[])memCache);
        this.cacheDirectory = CachedInputStream.nullSafeCacheDirectory(cacheDirectory);
        this.firstRead = false;
        this.needNewStream = true;
        if (memCache != null) {
            this.length = memCache.length;
        }
    }

    CachedInputStream(CachedStreamFactory factory, File cacheDirectory, File cacheFile) {
        this.factory = factory;
        this.tracker = new CachedStreamFactory.MemoryTracker(factory);
        this.fileCache = cacheFile;
        this.cacheDirectory = CachedInputStream.nullSafeCacheDirectory(cacheDirectory);
        this.firstRead = false;
        this.needNewStream = true;
        if (cacheFile != null && cacheFile.exists() && cacheFile.isFile()) {
            this.length = (int)cacheFile.length();
        }
    }

    private static File nullSafeCacheDirectory(File cacheDir) {
        if (cacheDir == null) {
            return FileUtils.getTempDirectory();
        }
        return cacheDir;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markpos = this.pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.pos = this.markpos;
        this.markpos = -1;
    }

    public boolean isInMemory() {
        return this.fileCache == null;
    }

    @Override
    public int read() throws IOException {
        int cursor;
        if (this.disposed) {
            throw new IOException("CachedInputStream has been disposed.");
        }
        if ((cursor = this.pos++) < this.count) {
            int val = -1;
            if (this.isInMemory()) {
                val = this.memOutputStream != null ? this.memOutputStream.getByte(cursor) : (cursor >= this.memCache.length ? -1 : this.memCache[cursor] & 0xFF);
            } else {
                this.randomAccessFile.seek(cursor);
                val = this.randomAccessFile.read();
            }
            if (val != -1) {
                ++this.pos;
            }
            return val;
        }
        int b = this.realRead();
        if (b != -1) {
            ++this.count;
        }
        return b;
    }

    private int realRead() throws IOException {
        if (this.needNewStream) {
            this.createInputStreamFromCache();
        }
        if (this.firstRead) {
            int read = this.inputStream.read();
            if (read == -1) {
                return read;
            }
            if (this.randomAccessFile != null) {
                this.randomAccessFile.write(read);
            } else if (!this.tracker.hasEnoughAvailableMemory(this.memOutputStream, 1)) {
                this.cacheToFile();
                this.randomAccessFile.write(read);
            } else {
                this.memOutputStream.write(read);
            }
            this.cacheEmpty = false;
            return read;
        }
        int read = this.inputStream.read();
        this.cacheEmpty = false;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.disposed) {
            throw new IOException("CachedInputStream has been disposed.");
        }
        int cursor = this.pos;
        int read = 0;
        if (cursor < this.count) {
            int toRead = Math.min(len, this.count - cursor);
            if (this.isInMemory()) {
                if (this.memOutputStream != null) {
                    byte[] bytes = new byte[toRead];
                    read = this.memOutputStream.getBytes(bytes, cursor);
                    System.arraycopy(bytes, 0, b, off, toRead);
                } else if (cursor >= this.memCache.length) {
                    read = -1;
                } else {
                    System.arraycopy(this.memCache, cursor, b, off, toRead);
                    read = toRead;
                }
            } else {
                this.randomAccessFile.seek(cursor);
                read = this.randomAccessFile.read(b, off, toRead);
            }
            if (read != -1) {
                this.pos += read;
            }
        }
        if (read != -1 && read < len) {
            int maxToRead = len - read;
            int remainingRead = this.realRead(b, off + read, maxToRead);
            if (remainingRead != -1) {
                this.pos += remainingRead;
                this.count += remainingRead;
            }
            read += remainingRead;
        }
        return read;
    }

    private int realRead(byte[] b, int off, int len) throws IOException {
        if (this.needNewStream) {
            this.createInputStreamFromCache();
        }
        int num = this.inputStream.read(b, off, len);
        this.cacheEmpty = false;
        if (num == -1) {
            return num;
        }
        if (this.firstRead) {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.write(b, off, num);
            } else if (!this.tracker.hasEnoughAvailableMemory(this.memOutputStream, num)) {
                this.cacheToFile();
                this.randomAccessFile.write(b, off, num);
            } else {
                this.memOutputStream.write(b, off, num);
            }
        }
        return num;
    }

    public void enforceFullCaching() throws IOException {
        if (this.firstRead) {
            IOUtils.copy((InputStream)this, (OutputStream)new NullOutputStream());
            this.length = this.count;
            this.firstRead = false;
        }
    }

    public void rewind() {
        if (!this.cacheEmpty) {
            if (this.firstRead) {
                try {
                    this.enforceFullCaching();
                }
                catch (IOException e) {
                    throw new StreamException("Could not read entire stream so rewind() can occur safely.", e);
                }
            }
            this.resetStream();
        }
    }

    private void resetStream() {
        IOUtils.closeQuietly((InputStream)this.inputStream);
        IOUtils.closeQuietly((OutputStream)this.memOutputStream);
        IOUtils.closeQuietly((Closeable)this.randomAccessFile);
        this.randomAccessFile = null;
        this.firstRead = false;
        this.needNewStream = true;
        if (this.memOutputStream != null) {
            LOG.debug((Object)"Creating memory cache from cached stream.");
            this.memCache = this.memOutputStream.toByteArray();
            this.memOutputStream = null;
        }
        this.pos = 0;
        this.markpos = -1;
        this.count = 0;
    }

    public void dispose() throws IOException {
        if (this.memCache != null) {
            this.memCache = null;
        }
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.memOutputStream != null) {
            this.memOutputStream.flush();
            this.memOutputStream.close();
            this.memOutputStream = null;
        }
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        if (this.fileCache != null) {
            FileUtil.delete(this.fileCache);
            LOG.debug((Object)("Deleted cache file: " + this.fileCache));
        }
        this.disposed = true;
        this.cacheEmpty = true;
    }

    @Override
    public int available() throws IOException {
        if (this.needNewStream) {
            this.createInputStreamFromCache();
        }
        if (this.inputStream == null) {
            return 0;
        }
        return this.inputStream.available();
    }

    @Override
    public final File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public boolean isCacheEmpty() {
        return this.cacheEmpty;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public long getMemCacheSize() {
        if (this.memCache != null) {
            return this.memCache.length;
        }
        if (this.memOutputStream != null) {
            return this.memOutputStream.size();
        }
        return 0L;
    }

    public int length() {
        if (this.length == -42) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Obtaining stream length before a stream of unknown lenght was fully read. This forces a full read just to get the length. To avoid this extra read cycle, consider calling the length() method after the stream has been fully read at least once through regular usage.");
            }
            int savedPos = this.pos;
            int savedMarkpos = this.markpos;
            try {
                this.enforceFullCaching();
                this.resetStream();
                IOUtils.skip((InputStream)this, (long)savedPos);
            }
            catch (IOException e) {
                throw new StreamException("Could not read entire stream to obtain its byte length.", e);
            }
            this.pos = savedPos;
            this.markpos = savedMarkpos;
        }
        return this.length;
    }

    public CachedInputStream newInputStream(File file) {
        return this.factory.newInputStream(file);
    }

    public CachedInputStream newInputStream(InputStream is) {
        return this.factory.newInputStream(is);
    }

    public CachedStreamFactory getStreamFactory() {
        return this.factory;
    }

    private void cacheToFile() throws IOException {
        this.fileCache = File.createTempFile("CachedInputStream-", "-temp", this.cacheDirectory);
        this.fileCache.deleteOnExit();
        LOG.debug((Object)("Reached max cache size. Swapping to file: " + this.fileCache));
        this.randomAccessFile = new RandomAccessFile(this.fileCache, "rw");
        this.randomAccessFile.write(this.memOutputStream.toByteArray());
        this.memOutputStream = null;
    }

    private void createInputStreamFromCache() throws FileNotFoundException {
        if (this.fileCache != null) {
            LOG.debug((Object)"Creating new input stream from file cache.");
            this.randomAccessFile = new RandomAccessFile(this.fileCache, "r");
            FileChannel channel = this.randomAccessFile.getChannel();
            this.inputStream = Channels.newInputStream(channel);
        } else {
            LOG.debug((Object)"Creating new input stream from memory cache.");
            this.inputStream = new ByteArrayInputStream(this.memCache);
        }
        this.needNewStream = false;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

