/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.file.FileUtil;
import com.norconex.commons.lang.io.ByteArrayOutputStream;
import com.norconex.commons.lang.io.CachedInputStream;
import com.norconex.commons.lang.io.CachedStreamFactory;
import com.norconex.commons.lang.io.ICachedStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CachedOutputStream
extends OutputStream
implements ICachedStream {
    private static final Logger LOG = LogManager.getLogger(CachedOutputStream.class);
    private final CachedStreamFactory factory;
    private final CachedStreamFactory.MemoryTracker tracker;
    private OutputStream outputStream;
    private byte[] memCache;
    private ByteArrayOutputStream memOutputStream;
    private File fileCache;
    private OutputStream fileOutputStream;
    private boolean doneWriting = false;
    private boolean closed = false;
    private boolean cacheEmpty = true;
    private final File cacheDirectory;

    CachedOutputStream(CachedStreamFactory factory, File cacheDirectory, OutputStream out) {
        this.factory = factory;
        this.tracker = new CachedStreamFactory.MemoryTracker(factory);
        this.memOutputStream = new ByteArrayOutputStream();
        if (out != null) {
            this.outputStream = out instanceof BufferedOutputStream ? out : new BufferedOutputStream(out);
        }
        this.cacheDirectory = cacheDirectory == null ? FileUtils.getTempDirectory() : cacheDirectory;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.doneWriting) {
            throw new IllegalStateException("Cannot write to this closed output stream.");
        }
        if (this.outputStream != null) {
            this.outputStream.write(b);
        }
        if (this.fileOutputStream != null) {
            this.fileOutputStream.write(b);
        } else if (!this.tracker.hasEnoughAvailableMemory(this.memOutputStream, 1)) {
            this.cacheToFile();
            this.fileOutputStream.write(b);
        } else {
            this.memOutputStream.write(b);
        }
        this.cacheEmpty = false;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.doneWriting) {
            throw new IllegalStateException("Cannot write to this closed output stream.");
        }
        if (this.outputStream != null) {
            this.outputStream.write(b, off, len);
        }
        if (this.fileOutputStream != null) {
            this.fileOutputStream.write(b, off, len);
        } else if (!this.tracker.hasEnoughAvailableMemory(this.memOutputStream, len - off)) {
            this.cacheToFile();
            this.fileOutputStream.write(b, off, len);
        } else {
            this.memOutputStream.write(b, 0, len);
        }
        this.cacheEmpty = false;
    }

    public CachedInputStream getInputStream() throws IOException {
        CachedInputStream is;
        if (this.closed) {
            throw new IllegalStateException("Cannot get CachedInputStream on a closed CachedOutputStream.");
        }
        if (this.fileCache != null) {
            is = this.factory.newInputStream(this.fileCache);
        } else if (this.memCache != null) {
            is = this.factory.newInputStream(this.memCache);
        } else {
            this.memCache = this.memOutputStream.toByteArray();
            this.memOutputStream.close();
            this.memOutputStream = null;
            is = this.factory.newInputStream(this.memCache);
        }
        this.close(false);
        return is;
    }

    private void close(boolean clearCache) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.memCache != null && clearCache) {
                this.memCache = null;
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                IOUtils.closeQuietly((OutputStream)this.outputStream);
                this.outputStream = null;
            }
            if (this.fileOutputStream != null) {
                this.fileOutputStream.flush();
                IOUtils.closeQuietly((OutputStream)this.fileOutputStream);
                this.fileOutputStream = null;
            }
            if (this.fileCache != null && clearCache) {
                FileUtil.delete(this.fileCache);
                LOG.debug((Object)("Deleted cache file: " + this.fileCache));
                this.fileCache = null;
            }
            if (this.memOutputStream != null && clearCache) {
                this.memOutputStream.flush();
                this.memOutputStream.close();
                this.memOutputStream = null;
            }
            this.cacheEmpty = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    @Override
    public final File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public CachedStreamFactory getStreamFactory() {
        return this.factory;
    }

    public boolean isCacheEmpty() {
        return this.cacheEmpty;
    }

    public CachedOutputStream newOuputStream(OutputStream os) {
        return this.factory.newOuputStream(os);
    }

    public CachedOutputStream newOuputStream() {
        return this.factory.newOuputStream();
    }

    @Override
    public long getMemCacheSize() {
        if (this.memCache != null) {
            return this.memCache.length;
        }
        if (this.memOutputStream != null) {
            return this.memOutputStream.size();
        }
        return 0L;
    }

    private void cacheToFile() throws IOException {
        this.fileCache = File.createTempFile("CachedOutputStream-", "-temp", this.cacheDirectory);
        this.fileCache.deleteOnExit();
        LOG.debug((Object)("Reached max cache size. Swapping to file: " + this.fileCache));
        RandomAccessFile f = new RandomAccessFile(this.fileCache, "rw");
        FileChannel channel = f.getChannel();
        this.fileOutputStream = Channels.newOutputStream(channel);
        IOUtils.write((byte[])this.memOutputStream.toByteArray(), (OutputStream)this.fileOutputStream);
        this.memOutputStream = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

