/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.io.ByteArrayOutputStream;
import com.norconex.commons.lang.io.CachedInputStream;
import com.norconex.commons.lang.io.CachedOutputStream;
import com.norconex.commons.lang.io.ICachedStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class CachedStreamFactory {
    private final int poolMaxMemory;
    private final int instanceMaxMemory;
    private final File cacheDirectory;
    private final Map<ICachedStream, Void> streams = Collections.synchronizedMap(new WeakHashMap());

    public CachedStreamFactory(int poolMaxMemory, int instanceMaxMemory) {
        this(poolMaxMemory, instanceMaxMemory, null);
    }

    public CachedStreamFactory(int poolMaxMemory, int instanceMaxMemory, File cacheDirectory) {
        this.poolMaxMemory = poolMaxMemory;
        this.instanceMaxMemory = instanceMaxMemory;
        this.cacheDirectory = cacheDirectory == null ? FileUtils.getTempDirectory() : cacheDirectory;
    }

    public int getPoolMaxMemory() {
        return this.poolMaxMemory;
    }

    public int getInstanceMaxMemory() {
        return this.instanceMaxMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPoolCurrentMemory() {
        int byteSize = 0;
        Map<ICachedStream, Void> map = this.streams;
        synchronized (map) {
            for (ICachedStream stream : this.streams.keySet()) {
                if (stream == null) continue;
                byteSize = (int)((long)byteSize + stream.getMemCacheSize());
            }
        }
        return byteSize;
    }

    int getPoolRemainingMemory() {
        return Math.max(0, this.poolMaxMemory - this.getPoolCurrentMemory());
    }

    CachedInputStream newInputStream(byte[] bytes) {
        return this.registerStream(new CachedInputStream(this, this.cacheDirectory, bytes));
    }

    public CachedInputStream newInputStream() {
        return this.newInputStream("");
    }

    public CachedInputStream newInputStream(String content) {
        return this.registerStream(new CachedInputStream(this, this.cacheDirectory, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8)));
    }

    public CachedInputStream newInputStream(File file) {
        return this.registerStream(new CachedInputStream(this, this.cacheDirectory, file));
    }

    public CachedInputStream newInputStream(InputStream is) {
        return this.registerStream(new CachedInputStream(this, this.cacheDirectory, is));
    }

    public CachedOutputStream newOuputStream(OutputStream os) {
        return this.registerStream(new CachedOutputStream(this, this.cacheDirectory, os));
    }

    public CachedOutputStream newOuputStream() {
        return this.registerStream(new CachedOutputStream(this, this.cacheDirectory, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ICachedStream> T registerStream(T s) {
        Map<ICachedStream, Void> map = this.streams;
        synchronized (map) {
            this.streams.put(s, null);
        }
        return s;
    }

    public class MemoryTracker {
        private static final int CHECK_CHUNK_SIZE = 1024;
        private int poolRemaining = -1;
        private int kbReadSoFar = -1;

        public boolean hasEnoughAvailableMemory(ByteArrayOutputStream memOutputStream, int bytesToAdd) {
            int remainingMemory;
            int kbRead = memOutputStream.size() / 1024;
            if (kbRead != this.kbReadSoFar) {
                this.kbReadSoFar = kbRead;
                this.poolRemaining = CachedStreamFactory.this.getPoolRemainingMemory();
            }
            return bytesToAdd <= (remainingMemory = Math.min(this.poolRemaining, CachedStreamFactory.this.getInstanceMaxMemory() - memOutputStream.size()));
        }
    }
}

