/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.io.IInputStreamFilter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class FilteredInputStream
extends InputStream {
    private final BufferedReader bufferedInput;
    private final IInputStreamFilter filter;
    private final Charset encoding;
    private InputStream lineStream;
    private boolean closed = false;

    public FilteredInputStream(InputStream is, IInputStreamFilter filter) throws IOException {
        this(is, filter, StandardCharsets.UTF_8);
    }

    public FilteredInputStream(InputStream is, IInputStreamFilter filter, Charset encoding) throws IOException {
        this.encoding = encoding == null ? StandardCharsets.UTF_8 : encoding;
        this.bufferedInput = new BufferedReader(new InputStreamReader(is, this.encoding));
        this.filter = filter;
        this.nextLine();
    }

    public FilteredInputStream(InputStream is, IInputStreamFilter filter, String encoding) throws IOException {
        this(is, filter, Charset.forName(encoding));
    }

    @Override
    public int read() throws IOException {
        if (this.lineStream == null) {
            return -1;
        }
        int ch = this.lineStream.read();
        if (ch == -1) {
            if (!this.nextLine()) {
                return -1;
            }
            return this.read();
        }
        return ch;
    }

    private boolean nextLine() throws IOException {
        String line;
        if (this.lineStream != null) {
            this.lineStream.close();
            this.lineStream = null;
        }
        if (this.closed) {
            return false;
        }
        while ((line = this.bufferedInput.readLine()) != null) {
            if (!this.filter.accept(line)) continue;
            line = line + "\n";
            this.lineStream = new ByteArrayInputStream(line.getBytes(this.encoding));
            return true;
        }
        this.bufferedInput.close();
        this.closed = true;
        return false;
    }
}

