/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class IOUtil {
    private static final String[] EMPTY_STRINGS = new String[0];

    private IOUtil() {
    }

    public static boolean startsWith(InputStream is, byte[] bytes) throws IOException {
        if (is == null || bytes == null) {
            return false;
        }
        byte[] head = IOUtil.borrowBytes(is, bytes.length);
        return Arrays.equals(bytes, head);
    }

    public static byte[] borrowBytes(InputStream is, int qty) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (!is.markSupported()) {
            throw new IllegalArgumentException("Input stream must support mark.");
        }
        is.mark(qty);
        byte[] bytes = new byte[qty];
        is.read(bytes);
        is.reset();
        return bytes;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        if (BufferedReader.class.isAssignableFrom(reader.getClass())) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static BufferedInputStream toBufferedInputStream(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        if (BufferedInputStream.class.isAssignableFrom(in.getClass())) {
            return (BufferedInputStream)in;
        }
        return new BufferedInputStream(in);
    }

    public static String[] tail(InputStream is, int lineQty) throws IOException {
        return IOUtil.tail(is, StandardCharsets.UTF_8, lineQty);
    }

    public static String[] tail(InputStream is, String encoding, int lineQty) throws IOException {
        return IOUtil.tail(is, Charset.forName(encoding), lineQty);
    }

    public static String[] tail(InputStream is, Charset encoding, int lineQty) throws IOException {
        String line;
        if (is == null) {
            return EMPTY_STRINGS;
        }
        Charset safeEncoding = encoding;
        if (safeEncoding == null) {
            safeEncoding = StandardCharsets.UTF_8;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, safeEncoding));
        ArrayList<String> lines = new ArrayList<String>(lineQty);
        while ((line = br.readLine()) != null) {
            lines.add(0, line);
            if (lines.size() <= lineQty) continue;
            lines.remove(lineQty);
        }
        br.close();
        Collections.reverse(lines);
        return lines.toArray(EMPTY_STRINGS);
    }

    public static String[] head(InputStream is, int lineQty) throws IOException {
        return IOUtil.head(is, StandardCharsets.UTF_8, lineQty);
    }

    public static String[] head(InputStream is, String encoding, int lineQty) throws IOException {
        return IOUtil.head(is, Charset.forName(encoding), lineQty);
    }

    public static String[] head(InputStream is, Charset encoding, int lineQty) throws IOException {
        String line;
        if (is == null) {
            return EMPTY_STRINGS;
        }
        Charset safeEncoding = encoding;
        if (safeEncoding == null) {
            safeEncoding = StandardCharsets.UTF_8;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, safeEncoding));
        ArrayList<String> lines = new ArrayList<String>(lineQty);
        while ((line = br.readLine()) != null) {
            lines.add(line);
            if (lines.size() != lineQty) continue;
        }
        br.close();
        return lines.toArray(EMPTY_STRINGS);
    }
}

