/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.io.IInputStreamListener;
import com.norconex.commons.lang.io.StreamException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class InputStreamConsumer
extends Thread {
    public static final int DEFAULT_CHUNK_SIZE = 1024;
    private final List<IInputStreamListener> listeners = Collections.synchronizedList(new ArrayList());
    private final InputStream input;
    private final String type;
    private final int chunkSize;

    public InputStreamConsumer(InputStream input) {
        this(input, null, new IInputStreamListener[0]);
    }

    public InputStreamConsumer(InputStream input, String type, IInputStreamListener ... listeners) {
        this(input, 1024, type, listeners);
    }

    public InputStreamConsumer(InputStream input, int chunkSize, String type, IInputStreamListener ... listeners) {
        super("StreamConsumer" + (type == null ? "" : "-" + type));
        this.input = input;
        this.type = type;
        this.chunkSize = chunkSize;
        if (!ArrayUtils.isEmpty((Object[])listeners)) {
            this.listeners.addAll(0, Arrays.asList(listeners));
        }
    }

    @Override
    public void run() {
        this.beforeStreaming();
        try {
            int length;
            byte[] buffer = new byte[this.chunkSize];
            while ((length = this.input.read(buffer)) != -1) {
                this.fireStreamed(buffer, length);
            }
            this.fireStreamed(ArrayUtils.EMPTY_BYTE_ARRAY, -1);
        }
        catch (IOException e) {
            throw new StreamException("Problem consuming input stream.", e);
        }
        this.afterStreaming();
    }

    public IInputStreamListener[] getStreamListeners() {
        return this.listeners.toArray(new IInputStreamListener[0]);
    }

    public String getType() {
        return this.type;
    }

    protected void beforeStreaming() {
    }

    protected void afterStreaming() {
    }

    public synchronized void startAndWait() {
        this.start();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new StreamException("Streaming interrupted.", e);
        }
    }

    private synchronized void fireStreamed(byte[] bytes, int length) {
        for (IInputStreamListener listener : this.listeners) {
            listener.streamed(this.type, bytes, length);
        }
    }

    public static void consume(InputStream input) {
        InputStreamConsumer.consume(input, null, new IInputStreamListener[0]);
    }

    public static void consume(InputStream input, String type, IInputStreamListener ... listeners) {
        InputStreamConsumer.consume(input, 1024, type, new IInputStreamListener[0]);
    }

    public static void consume(InputStream input, int chunkSize, String type, IInputStreamListener ... listeners) {
        new InputStreamConsumer(input, chunkSize, type, listeners).start();
    }

    public static void consumeAndWait(InputStream input) {
        InputStreamConsumer.consumeAndWait(input, null, new IInputStreamListener[0]);
    }

    public static void consumeAndWait(InputStream input, String type, IInputStreamListener ... listeners) {
        InputStreamConsumer.consumeAndWait(input, 1024, type, new IInputStreamListener[0]);
    }

    public static void consumeAndWait(InputStream input, int chunkSize, String type, IInputStreamListener ... listeners) {
        new InputStreamConsumer(input, chunkSize, type, listeners).startAndWait();
    }
}

