/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.io.ByteArrayOutputStream;
import com.norconex.commons.lang.io.IInputStreamListener;
import com.norconex.commons.lang.io.StreamException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.Charsets;

public abstract class InputStreamLineListener
implements IInputStreamListener {
    private static final byte NL = 10;
    private static final byte CR = 13;
    private static final byte RESET = 0;
    private final Map<String, Buffer> buffers = new HashMap<String, Buffer>();
    private final Charset charset;

    public InputStreamLineListener() {
        this(StandardCharsets.UTF_8);
    }

    public InputStreamLineListener(Charset charset) {
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
    }

    public InputStreamLineListener(String charset) {
        this.charset = charset == null ? StandardCharsets.UTF_8 : Charsets.toCharset((String)charset);
    }

    @Override
    public void streamed(String type, byte[] bytes, int length) {
        Buffer buffer = this.getBuffer(type);
        if (length == -1) {
            if (!buffer.lastEmpty) {
                this.flushBuffer(type, buffer);
            }
            return;
        }
        for (int i = 0; i < length; ++i) {
            byte b = bytes[i];
            if (this.isEOL(b)) {
                if (this.isEOL(buffer.lastEolByte) && b != buffer.lastEolByte) {
                    buffer.lastEolByte = (byte)0;
                    continue;
                }
                this.flushBuffer(type, buffer);
                buffer.lastEolByte = b;
                continue;
            }
            buffer.lastEolByte = (byte)0;
            buffer.baos.write(b);
            buffer.lastEmpty = false;
        }
    }

    protected abstract void lineStreamed(String var1, String var2);

    private boolean isEOL(byte b) {
        return b == 10 || b == 13;
    }

    private void flushBuffer(String type, Buffer buffer) {
        try {
            this.lineStreamed(type, buffer.baos.toString(this.charset.toString()));
            buffer.baos.reset();
            buffer.lastEmpty = true;
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException("Unsupported charset: " + this.charset, e);
        }
    }

    private synchronized Buffer getBuffer(String type) {
        Buffer buf;
        String key = type;
        if (key == null) {
            key = "";
        }
        if ((buf = this.buffers.get(key)) == null) {
            buf = new Buffer();
            this.buffers.put(key, buf);
        }
        return buf;
    }

    class Buffer {
        private boolean lastEmpty = true;
        private byte lastEolByte = 0;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        Buffer() {
        }
    }
}

