/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ReverseFileInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private final RandomAccessFile raf;
    private long currentPositionInFile;
    private int currentPositionInBuffer;

    public ReverseFileInputStream(File file) throws IOException {
        ReverseFileInputStream.assertFile(file);
        this.raf = new RandomAccessFile(file, "r");
        this.currentPositionInFile = this.raf.length();
        this.currentPositionInBuffer = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.currentPositionInFile <= 0L) {
            return -1;
        }
        if (--this.currentPositionInBuffer < 0) {
            this.currentPositionInBuffer = this.buffer.length;
            long startOfBlock = this.currentPositionInFile - (long)this.buffer.length;
            if (startOfBlock < 0L) {
                this.currentPositionInBuffer = this.buffer.length + (int)startOfBlock;
                startOfBlock = 0L;
            }
            this.raf.seek(startOfBlock);
            this.raf.readFully(this.buffer, 0, this.currentPositionInBuffer);
            return this.read();
        }
        --this.currentPositionInFile;
        return this.buffer[this.currentPositionInBuffer];
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    private static void assertFile(File file) throws IOException {
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            throw new IOException("Not a valid file: " + file);
        }
    }
}

