/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.io.IStreamListener;
import com.norconex.commons.lang.io.StreamException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@Deprecated
public class StreamGobbler
extends Thread {
    private static final Logger LOG = LogManager.getLogger(StreamGobbler.class);
    private final List<IStreamListener> listeners = Collections.synchronizedList(new ArrayList());
    private final InputStream is;
    private final String type;
    private final String encoding;

    public StreamGobbler(InputStream is) {
        this(is, null);
    }

    public StreamGobbler(InputStream is, String type) {
        this(is, type, null);
    }

    public StreamGobbler(InputStream is, String type, String encoding) {
        super("StreamGobbler" + (type == null ? "" : "-" + type));
        this.is = is;
        this.type = type;
        this.encoding = encoding;
    }

    @Override
    public void run() {
        this.beforeStreaming();
        try {
            String safeEncoding = this.encoding;
            if (StringUtils.isBlank((CharSequence)safeEncoding)) {
                safeEncoding = "UTF-8";
            }
            InputStreamReader isr = new InputStreamReader(this.is, safeEncoding);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                this.fireLineStreamed(line);
            }
        }
        catch (IOException e) {
            throw new StreamException("Problem gobbling input stream.", e);
        }
        this.afterStreaming();
    }

    public synchronized void addStreamListener(IStreamListener ... l) {
        this.listeners.addAll(0, Arrays.asList(l));
    }

    public synchronized void removeStreamListener(IStreamListener listener) {
        this.listeners.remove(listener);
    }

    public IStreamListener[] getStreamListeners() {
        return this.listeners.toArray(new IStreamListener[0]);
    }

    protected void beforeStreaming() {
    }

    protected void afterStreaming() {
    }

    public String getType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private synchronized void fireLineStreamed(String line) {
        if (LOG.isDebugEnabled()) {
            if (this.type != null) {
                LOG.debug((Object)(this.type + ":" + line));
            } else {
                LOG.debug((Object)line);
            }
        }
        for (IStreamListener listener : this.listeners) {
            listener.lineStreamed(this.type, line);
        }
    }
}

