/*
 * Decompiled with CFR 0.152.
 */
package com.norconex.commons.lang.io;

import com.norconex.commons.lang.io.IOUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TextReader
extends Reader {
    private static final Logger LOG = LogManager.getLogger(TextReader.class);
    public static final int DEFAULT_MAX_READ_SIZE = 10000000;
    private final BufferedReader reader;
    private final int maxReadSize;
    private final boolean removeTrailingDelimiter;
    private final StringBuilder buffer = new StringBuilder();
    private static final int PATTERN_FLAGS = 288;
    private static final Pattern PARAGRAPH_PATTERN = Pattern.compile("^.*(\\p{javaWhitespace}*[\\n\\r]\\p{javaWhitespace}*?[\\n\\r]\\p{javaWhitespace}*)", 288);
    private static final Pattern SENTENCE_PATTERN = Pattern.compile("^.*[\\.\\?\\!](\\p{javaWhitespace}+|$)", 288);
    private static final Pattern WORD_PATTERN = Pattern.compile("^.*(\\p{javaWhitespace}+)", 288);

    public TextReader(Reader reader) {
        this(reader, 10000000);
    }

    public TextReader(Reader reader, int maxReadSize) {
        this(reader, maxReadSize, false);
    }

    public TextReader(Reader reader, int maxReadSize, boolean removeTrailingDelimiter) {
        this.maxReadSize = maxReadSize;
        this.reader = IOUtil.toBufferedReader(reader);
        this.removeTrailingDelimiter = removeTrailingDelimiter;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }

    public String readText() throws IOException {
        if (this.maxReadSize == -1) {
            String txt = IOUtils.toString((Reader)this.reader);
            if (StringUtils.isEmpty((CharSequence)txt)) {
                return null;
            }
            return txt;
        }
        char[] text = new char[this.maxReadSize - this.buffer.length()];
        int num = this.reader.read(text);
        if (num == -1) {
            return null;
        }
        this.buffer.append(String.valueOf(text, 0, num));
        this.reader.mark(1);
        if (this.reader.read() == -1) {
            String t = this.buffer.toString();
            this.buffer.setLength(0);
            this.reader.reset();
            return t;
        }
        this.reader.reset();
        Matcher m = PARAGRAPH_PATTERN.matcher(this.buffer);
        if (m.find()) {
            int mEnd;
            int mStart = m.start(1);
            int substringEnd = mEnd = m.end(1);
            if (this.removeTrailingDelimiter) {
                substringEnd = mStart;
            }
            String t = this.buffer.substring(0, substringEnd);
            this.buffer.delete(0, substringEnd);
            LOG.debug((Object)"Reader text split after paragraph.");
            return t;
        }
        m = SENTENCE_PATTERN.matcher(this.buffer);
        if (m.find()) {
            int mEnd;
            int mStart = m.start(1);
            int substringEnd = mEnd = m.end(1);
            if (this.removeTrailingDelimiter) {
                substringEnd = mStart;
            }
            String t = this.buffer.substring(0, substringEnd);
            this.buffer.delete(0, substringEnd);
            LOG.debug((Object)"Reader text split after sentence.");
            return t;
        }
        m = WORD_PATTERN.matcher(this.buffer);
        if (m.find()) {
            int mEnd;
            int mStart = m.start(1);
            int substringEnd = mEnd = m.end(1);
            if (this.removeTrailingDelimiter) {
                substringEnd = mStart;
            }
            String t = this.buffer.substring(0, substringEnd);
            this.buffer.delete(0, substringEnd);
            LOG.debug((Object)"Reader text split after word.");
            return t;
        }
        String t = this.buffer.toString();
        this.buffer.setLength(0);
        LOG.debug((Object)"Reader text split after maxReadSize.");
        return t;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

